"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const isFunction_1 = __importDefault(require("./isFunction"));
const VALID_NAMES = ["File", "Blob"];
const isFile = (value) => Boolean(value
    && typeof value === "object"
    && isFunction_1.default(value.constructor)
    && VALID_NAMES.includes(value[Symbol.toStringTag])
    && isFunction_1.default(value.stream)
    && value.name != null
    && value.size != null
    && value.lastModified != null);
exports.default = isFile;
