"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTooltip = exports.getParamValue = exports.getLabel = exports.getFormListLayout = void 0;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var getParamValue = exports.getParamValue = function getParamValue(formCtx, upperCtx, schema) {
  return function (valueKey) {
    var _a, _b;
    return (_b = (_a = schema[valueKey]) !== null && _a !== void 0 ? _a : upperCtx[valueKey]) !== null && _b !== void 0 ? _b : formCtx[valueKey];
  };
};
var getFormListLayout = exports.getFormListLayout = function getFormListLayout(getValueFromKey, displayType) {
  var _labelCol = getValueFromKey('labelCol');
  var _fieldCol = getValueFromKey('fieldCol');
  var labelWidth = getValueFromKey('labelWidth');
  var labelCol = {
    span: 5
  };
  var fieldCol = {
    flex: 1
  };
  if (labelWidth && displayType !== 'column') {
    labelCol = {
      flex: labelWidth + 'px'
    };
  }
  if (_labelCol) {
    labelCol = _labelCol;
  }
  if (_fieldCol) {
    fieldCol = _fieldCol;
  }
  if (typeof _labelCol === 'number') {
    labelCol = {
      span: _labelCol
    };
  }
  if (typeof _fieldCol === 'number') {
    fieldCol = {
      span: _fieldCol
    };
  }
  return {
    labelCol: labelCol,
    fieldCol: fieldCol
  };
};
var getLabel = exports.getLabel = function getLabel(schema, displayType, widgets) {
  var title = schema.title,
    description = schema.description,
    descWidget = schema.descWidget,
    labelWidget = schema.labelWidget;
  var LabelNode = widgets[labelWidget];
  if (LabelNode) {
    return /*#__PURE__*/_react.default.createElement(LabelNode, {
      schema: schema
    });
  }
  if (!description && !descWidget) {
    return title;
  }
  var RenderDesc = function RenderDesc() {
    var Widget = widgets[descWidget];
    if (Widget) {
      return /*#__PURE__*/_react.default.createElement(Widget, {
        schema: schema
      });
    }
    if (description) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: 'fr-desc'
      }, "(", description, ")");
    }
    return null;
  };
  if (displayType === 'inline') {
    return title;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, /*#__PURE__*/_react.default.createElement(RenderDesc, null));
};
var getTooltip = exports.getTooltip = function getTooltip(schema, displayType) {
  var descType = schema.descType,
    description = schema.description,
    tooltip = schema.tooltip;
  if (tooltip) {
    if (typeof tooltip === 'string') {
      return {
        title: /*#__PURE__*/_react.default.createElement("span", {
          dangerouslySetInnerHTML: {
            __html: tooltip
          }
        })
      };
    }
    return Object.assign(Object.assign({}, tooltip), {
      title: /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: tooltip.title
        }
      })
    });
  }
  if (descType === 'widget' || !description) {
    return null;
  }
  if (displayType === 'column' && descType === 'icon') {
    return {
      title: description
    };
  }
  return null;
};