function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
import React from 'react';
import FieldItem from './FieldItem';
import FieldList from './FieldList';
import sortProperties from '../models/sortProperties';
import "./index.css";
;
;
var renderItem = function renderItem(props) {
  var _a;
  var schema = props.schema,
    key = props.key,
    path = props.path,
    rootPath = props.rootPath;
  // render List
  if (schema.type === 'array' && ((_a = schema.items) === null || _a === void 0 ? void 0 : _a.type) === 'object') {
    return /*#__PURE__*/React.createElement(FieldList, {
      key: key,
      schema: schema,
      path: path,
      rootPath: rootPath,
      renderCore: RenderCore
    });
  }
  // render Objiect | field
  var child = null;
  // has child schema
  if ((schema === null || schema === void 0 ? void 0 : schema.properties) && (schema === null || schema === void 0 ? void 0 : schema.widgetType) !== 'field') {
    child = RenderCore({
      schema: schema,
      parentPath: path,
      rootPath: rootPath
    });
    // path = undefined;
  }
  return /*#__PURE__*/React.createElement(FieldItem, {
    key: key,
    schema: schema,
    path: path,
    rootPath: rootPath,
    children: child,
    renderCore: RenderCore
  });
};
var RenderCore = function RenderCore(props) {
  var schema = props.schema,
    _props$parentPath = props.parentPath,
    parentPath = _props$parentPath === void 0 ? [] : _props$parentPath,
    _props$rootPath = props.rootPath,
    rootPath = _props$rootPath === void 0 ? [] : _props$rootPath;
  if (!schema || Object.keys(schema).length === 0) {
    return null;
  }
  // render List.item
  if (schema === null || schema === void 0 ? void 0 : schema.items) {
    return renderItem({
      schema: schema.items,
      path: parentPath,
      rootPath: rootPath
    });
  }
  // render Objiect | field
  return sortProperties(Object.entries(schema.properties || {})).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      item = _ref2[1];
    var path = [].concat(_toConsumableArray(parentPath), [key]);
    return renderItem({
      schema: item,
      path: path,
      key: key,
      rootPath: rootPath
    });
  });
};
export default RenderCore;