"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRealDataPath = getRealDataPath;
exports.getValueByPath = getValueByPath;
exports.parseExpression = exports.parseAllExpression = exports.isHasExpression = exports.isExpression = void 0;
var _lodashEs = require("lodash-es");
var _index = require("../utils/index");
var _formDataSkeleton = require("./formDataSkeleton");
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var isExpression = exports.isExpression = function isExpression(str) {
  if (typeof str !== 'string') {
    return false;
  }
  var pattern = /^\{\s*\{([\s\S]+)\}\s*\}$/;
  var reg1 = /^{\s*{function\(.+}\s*}$/;
  return str.match(pattern) && !str.match(reg1);
};
var _isHasExpression = exports.isHasExpression = function isHasExpression(schema) {
  var result = Object.keys(schema).some(function (key) {
    var item = schema[key];
    // 子协议不做递归确认
    if (key === 'properties') {
      return false;
    }
    var _recursionArray = function recursionArray(list) {
      var result = list.some(function (ite) {
        if ((0, _index.isArray)(ite)) {
          return _recursionArray(ite);
        }
        if ((0, _index.isObject)(ite)) {
          return _isHasExpression(ite);
        }
        return isExpression(ite);
      });
      return result;
    };
    if ((0, _index.isArray)(item)) {
      return _recursionArray(item);
    }
    if ((0, _index.isObject)(item)) {
      return _isHasExpression(item);
    }
    return isExpression(item);
  });
  return result;
};
var parseFunc = function parseFunc(funcBody) {
  var funcBodyTemp = funcBody.replace(/(\.|\?\.)/g, '?.'); // 将. 和 ?. 统一替换为?.
  var funcBodyStr = funcBodyTemp.replace(/(\d+)\?\.(\d+)/g, '$1.$2'); //  排除数字中的?.
  var result = _toConsumableArray(funcBodyStr).reduce(function (acc, char, index) {
    if (char === '[') {
      if (index > 0 && funcBodyStr[index - 1] !== '\n') {
        // 排除开头[]
        return "".concat(acc, "?.").concat(char);
      }
    }
    return "".concat(acc).concat(char);
  }, '');
  return result;
};
var parseExpression = exports.parseExpression = function parseExpression(func) {
  var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var parentPath = arguments.length > 2 ? arguments[2] : undefined;
  var parentData = (0, _lodashEs.get)(formData, parentPath) || {};
  if (typeof func === 'string') {
    var funcBody = func.replace(/^{\s*{/g, '').replace(/}\s*}$/g, '').trim();
    var isHandleData = (funcBody === null || funcBody === void 0 ? void 0 : funcBody.startsWith('formData')) || (funcBody === null || funcBody === void 0 ? void 0 : funcBody.startsWith('rootValue'));
    var funcBodyStr = isHandleData ? parseFunc(funcBody) : funcBody;
    var funcStr = "\n      return ".concat(funcBodyStr.replace(/formData/g, JSON.stringify(formData)).replace(/rootValue/g, JSON.stringify(parentData)), "\n    ");
    try {
      var result = Function(funcStr)();
      return result;
    } catch (error) {
      console.log(error, funcStr, parentPath);
      return null; // 如果计算有错误，return null 最合适
    }
  }
  return func;
};
function getRealDataPath(path) {
  if (typeof path !== 'string') {
    throw Error("id ".concat(path, " is not a string!!! Something wrong here"));
  }
  if (path.match(/[$]void_[^.]+$/)) {
    return undefined;
  }
  return path.replace(/[$]void_[^.]+./g, '');
}
function getValueByPath(formData, path) {
  if (path === '#' || !path) {
    return formData || {};
  } else if (typeof path === 'string') {
    var realPath = getRealDataPath(path);
    return realPath && (0, _lodashEs.get)(formData, realPath);
  } else {
    console.error('path has to be a string');
  }
}
var _parseAllExpression = exports.parseAllExpression = function parseAllExpression(_schema, _formData, dataPath, formSchema) {
  var schema = (0, _index._cloneDeep)(_schema);
  var formData = _formData;
  if (formSchema) {
    formData = (0, _formDataSkeleton.createDataSkeleton)(formSchema, formData);
  }
  var _recursionArray2 = function recursionArray(list) {
    var result = list.map(function (item) {
      if ((0, _index.isArray)(item)) {
        return _recursionArray2(item);
      }
      if ((0, _index.isObject)(item)) {
        return _parseAllExpression(item, formData, dataPath);
      }
      if (isExpression(item)) {
        return parseExpression(item, formData, dataPath);
      }
      return item;
    });
    return result;
  };
  Object.keys(schema).forEach(function (key) {
    var _a;
    var value = schema[key];
    if ((0, _index.isArray)(value)) {
      schema[key] = _recursionArray2(value);
    }
    if ((0, _index.isObject)(value) && ((_a = value.mustacheParse) !== null && _a !== void 0 ? _a : true)) {
      schema[key] = _parseAllExpression(value, formData, dataPath);
    } else if (isExpression(value)) {
      schema[key] = parseExpression(value, formData, dataPath);
    }
  });
  return schema;
};