"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _initializerDefineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/initializerDefineProperty"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _applyDecoratedDescriptor2 = _interopRequireDefault(require("@babel/runtime/helpers/applyDecoratedDescriptor"));

var _initializerWarningHelper2 = _interopRequireDefault(require("@babel/runtime/helpers/initializerWarningHelper"));

var _stream = require("stream");

var _util = require("util");

var _path = require("path");

var _mimeTypes = _interopRequireDefault(require("mime-types"));

var _getStreamIterator = _interopRequireDefault(require("./util/getStreamIterator"));

var _getLength = _interopRequireDefault(require("./util/getLength"));

var _isObject = _interopRequireDefault(require("./util/isObject"));

var _isStream = _interopRequireDefault(require("./util/isStream"));

var _boundary = _interopRequireDefault(require("./util/boundary"));

var _readOnly = _interopRequireDefault(require("./util/readOnly"));

var _isBlob = _interopRequireDefault(require("./util/isBlob"));

var _toFile = _interopRequireDefault(require("./util/toFile"));

let _Symbol$toStringTag, _Symbol$iterator, _Symbol$asyncIterator, _inspect$custom;

var _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _temp;

const {
  isBuffer
} = Buffer;
const {
  isArray
} = Array;
const {
  freeze
} = Object;
/**
 * FormData implementation for Node.js.
 *
 * @api public
 */

let FormData = (_class = (_temp = (_Symbol$toStringTag = Symbol.toStringTag, _Symbol$iterator = Symbol.iterator, _Symbol$asyncIterator = Symbol.asyncIterator, _inspect$custom = _util.inspect.custom, class FormData {
  /**
   * Generates a new boundary string once FormData instance constructed
   *
   * @type string
   *
   * @public
   */

  /**
   * Returns headers for multipart/form-data
   *
   * @type object
   *
   * @public
   */

  /**
   * Refers to the internal Readable stream
   *
   * @type stream.Readable
   *
   * @public
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type Map
   *
   * @private
   */

  /**
   * @type AsyncIterableIterator<Buffer>
   *
   * @private
   */

  /**
   * Returns a string representation of the FormData
   *
   * @return {string}
   */
  get [_Symbol$toStringTag]() {
    return "FormData";
  }
  /**
   * @param {array} fields – an optional FormData initial fields.
   *   Each field must be passed as a collection of the objects
   *   with "name", "value" and "filename" props.
   *   See the FormData#append() method for more information.
   */


  constructor(fields = null) {
    (0, _initializerDefineProperty2.default)(this, "boundary", _descriptor, this);
    (0, _initializerDefineProperty2.default)(this, "headers", _descriptor2, this);
    (0, _initializerDefineProperty2.default)(this, "stream", _descriptor3, this);
    (0, _initializerDefineProperty2.default)(this, "__carriage", _descriptor4, this);
    (0, _initializerDefineProperty2.default)(this, "__dashes", _descriptor5, this);
    (0, _initializerDefineProperty2.default)(this, "__footer", _descriptor6, this);
    (0, _initializerDefineProperty2.default)(this, "__defaultContentType", _descriptor7, this);
    (0, _initializerDefineProperty2.default)(this, "__content", _descriptor8, this);
    (0, _initializerDefineProperty2.default)(this, "__curr", _descriptor9, this);
    (0, _defineProperty2.default)(this, "__read", () => {
      const onFulfilled = ({
        done,
        value
      }) => {
        if (done) {
          return this.stream.push(null);
        }

        this.stream.push(isBuffer(value) ? value : Buffer.from(String(value)));
      };

      const onRejected = err => this.stream.emit("error", err);

      this.__curr.next().then(onFulfilled).catch(onRejected);
    });
    (0, _defineProperty2.default)(this, "inspect", this[_util.inspect.custom]);

    if (isArray(fields)) {
      this.__appendFromInitialFields(fields);
    }
  }
  /**
   * Returns a mime type by field's filename
   *
   * @private
   */


  __getMime(filename) {
    return _mimeTypes.default.lookup(filename) || this.__defaultContentType;
  }
  /**
   * Returns a headers for given field's data
   *
   * @private
   */


  __getHeader(name, filename) {
    let header = "";
    header += `${this.__dashes}${this.boundary}${this.__carriage}`;
    header += `Content-Disposition: form-data; name="${name}"`;

    if (filename) {
      header += `; filename="${filename}"${this.__carriage}`;
      header += `Content-Type: ${this.__getMime(filename)}`;
    }

    return `${header}${this.__carriage.repeat(2)}`;
  }
  /**
   * Get each field from internal Map
   *
   * @private
   */


  async *__getField() {
    for (const [name, {
      values
    }] of this.__content) {
      for (const {
        value,
        filename
      } of values) {
        // Set field's header
        yield this.__getHeader(name, filename);

        if ((0, _isBlob.default)(value)) {
          yield* (0, _getStreamIterator.default)(value.stream());
        } else if ((0, _isStream.default)(value)) {
          // Read the stream content
          yield* (0, _getStreamIterator.default)(value);
        } else {
          yield value;
        } // Add trailing carriage


        yield this.__carriage;
      }
    } // Add a footer when all fields ended


    yield this.__footer;
  }
  /**
   * Read values from internal storage and push it to the internal stream
   *
   * @return {void}
   *
   * @private
   */


  /**
   * Append initial fields
   *
   * @param {array} fields
   *
   * @return {void}
   *
   * @private
   */
  __appendFromInitialFields(fields) {
    for (const field of fields) {
      if ((0, _isObject.default)(field) && !isArray(field)) {
        this.append(field.name, field.value, field.filename, field.options);
      }
    }
  }
  /**
   * Appends a new value onto an existing key inside a FormData object,
   * or adds the key if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @param {object} [options = {}] An object with additional paramerets.
   *
   * @return {void}
   *
   * @private
   */


  __setField(name, value, filename, options, append, argsLength) {
    const methodName = append ? "append" : "set";

    if ((0, _isObject.default)(filename)) {
      [options, filename] = [filename, undefined];
    } // FormData required at least 2 arguments to be set.


    if (argsLength < 2) {
      throw new TypeError(`Failed to execute '${methodName}' on 'FormData': ` + `2 arguments required, but only ${argsLength} present.`);
    } // FormData requires the second argument to be some kind of binary data
    // when a filename has been set.


    if (filename && !((0, _isBlob.default)(value) || (0, _isStream.default)(value) || isBuffer(value))) {
      throw new TypeError(`Failed to execute '${methodName}' on 'FormData': ` + "parameter 2 is not one of the following types: ", "ReadableStream | ReadStream | Readable | Buffer | File | Blob");
    } // Get a filename for Buffer, Blob, File, ReadableStream and Readable values


    if (isBuffer(value) && filename) {
      filename = (0, _path.basename)(filename);
    } else if ((0, _isBlob.default)(value)) {
      filename = (0, _path.basename)(value.name || filename || value.constructor.name === "Blob" ? "blob" : String(value.name));
    } else if ((0, _isStream.default)(value) && (value.path || filename)) {
      // Readable stream which created from fs.createReadStream
      // have a "path" property. So, we can get a "filename"
      // from the stream itself.
      filename = (0, _path.basename)(value.path || filename);
    } // Normalize field content


    if ((0, _isStream.default)(value)) {
      if (options.size != null) {
        value = (0, _toFile.default)(value, filename || name || options.filename, options);
      }
    } else if ((0, _isBlob.default)(value) || isBuffer(value)) {
      value = (0, _toFile.default)(value, filename || name || options.filename, options);
    } else {
      value = String(value);
    }

    const field = this.__content.get(name); // Set a new field if given name is not exists


    if (!field) {
      return void this.__content.set(name, {
        append,
        values: [{
          value,
          filename
        }]
      });
    } // Replace a value of the existing field if "set" called


    if (!append) {
      return void this.__content.set(name, {
        append,
        values: [{
          value,
          filename
        }]
      });
    } // Do nothing if the field has been created from .set()


    if (!field.append) {
      return undefined;
    } // Append a new value to the existing field


    field.values.push({
      value,
      filename
    });

    this.__content.set(name, field);
  }
  /**
   * Returns computed length of the FormData content.
   * If data contains stream.Readable field(s),
   * the method will always return undefined.
   *
   * @return {Promise<number | undefined>}
   *
   * @public
   */


  async getComputedLength() {
    let length = 0;

    if (this.__content.size === 0) {
      return length;
    }

    const carriageLength = Buffer.from(this.__carriage).length;

    for (const [name, {
      values
    }] of this.__content) {
      for (const {
        value,
        filename
      } of values) {
        length += Buffer.from(this.__getHeader(name, filename)).length;
        const valueLength = await (0, _getLength.default)(value); // Return `undefined` if can't tell field's length
        // (it's probably a stream with unknown length)

        if (valueLength == null) {
          return undefined;
        }

        length += Number(valueLength) + carriageLength;
      }
    }

    return length + Buffer.from(this.__footer).length;
  }
  /**
   * Appends a new value onto an existing key inside a FormData object,
   * or adds the key if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @return {void}
   *
   * @public
   */


  append(name, value, filename = undefined, options = {}) {
    return this.__setField(name, value, filename, options, true, arguments.length);
  }
  /**
   * Set a new value for an existing key inside FormData,
   * or add the new field if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @return {void}
   *
   * @public
   */


  set(name, value, filename = undefined, options = {}) {
    return this.__setField(name, value, filename, options, false, arguments.length);
  }
  /**
   * Check if a field with the given name exists inside FormData.
   *
   * @param {string} name – A name of the field you want to test for.
   *
   * @return {boolean}
   *
   * @public
   */


  has(name) {
    return this.__content.has(name);
  }
  /**
   * Returns the first value associated with the given name.
   * Buffer and Readable values will be returned as-is.
   *
   * @param {string} name – A name of the value you want to retrieve.
   *
   * @public
   */


  get(name) {
    const field = this.__content.get(name);

    if (!field) {
      return undefined;
    }

    return field.values[0].value;
  }
  /**
   * Returns all the values associated with
   * a given key from within a FormData object.
   *
   * @param {string} name – A name of the value you want to retrieve.
   *
   * @public
   */


  getAll(name) {
    const field = this.__content.get(name);

    return field ? Array.from(field.values, ({
      value
    }) => value) : [];
  }
  /**
   * Deletes a key and its value(s) from a FormData object.
   *
   * @param {string} name – The name of the key you want to delete.
   *
   * @public
   */


  delete(name) {
    this.__content.delete(name);
  }
  /**
   * @return {IterableIterator<string>}
   */


  *keys() {
    for (const key of this.__content.keys()) {
      yield key;
    }
  }
  /**
   * @return {IterableIterator<[string, any]>}
   */


  *entries() {
    for (const name of this.keys()) {
      const values = this.getAll(name); // Yield each value of a field, like browser-side FormData does.

      for (const value of values) {
        yield [name, value];
      }
    }
  }
  /**
   * @return {IterableIterator<any>}
   */


  *values() {
    for (const [, values] of this) {
      yield values;
    }
  }
  /**
   * @return {IterableIterator<[string, any]>}
   */


  [_Symbol$iterator]() {
    return this.entries();
  }
  /**
   * Executes a given callback for each field of the FormData instance
   *
   * @param {function} fn – Function to execute for each element,
   *   taking three arguments:
   *     + {any} value – A value(s) of the current field.
   *     + {string} – Name of the current field.
   *     + {FormData} fd – The FormData instance that forEach
   *       is being applied to
   *
   * @param {any} [ctx = null]
   *
   * @public
   */


  forEach(fn, ctx = null) {
    for (const [name, value] of this) {
      fn.call(ctx, value, name, this);
    }
  }
  /**
   * This method allows to read a content from internal stream
   * using async generators and for-await-of APIs.
   * An alias of FormData#stream[Symbol.asyncIterator]()
   *
   * @return {AsyncIterableIterator<Buffer>}
   *
   * @public
   */


  [_Symbol$asyncIterator]() {
    return this.stream[Symbol.asyncIterator]();
  }
  /**
   * Alias of the FormData#[util.inspect.custom]()
   *
   * @return {string}
   */


  /**
   * Returns a string representation of the FormData
   *
   * @return {string}
   */
  toString() {
    return "[object FormData]";
  }

  [_inspect$custom]() {
    return "FormData";
  }

}), _temp), (_descriptor = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "boundary", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return `NodeJSFormDataStreamBoundary${(0, _boundary.default)()}`;
  }
}), _descriptor2 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "headers", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return freeze({
      "Content-Type": `multipart/form-data; boundary=${this.boundary}`
    });
  }
}), _descriptor3 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "stream", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return new _stream.Readable({
      read: () => this.__read()
    });
  }
}), _descriptor4 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__carriage", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "\r\n";
  }
}), _descriptor5 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__dashes", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "-".repeat(2);
  }
}), _descriptor6 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__footer", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return `${this.__dashes}${this.boundary}${this.__dashes}` + `${this.__carriage.repeat(2)}`;
  }
}), _descriptor7 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__defaultContentType", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "application/octet-stream";
  }
}), _descriptor8 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__content", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return new Map();
  }
}), _descriptor9 = (0, _applyDecoratedDescriptor2.default)(_class.prototype, "__curr", [_readOnly.default], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return this.__getField();
  }
})), _class);
var _default = FormData;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;