import _initializerDefineProperty from "@babel/runtime/helpers/initializerDefineProperty";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _applyDecoratedDescriptor from "@babel/runtime/helpers/applyDecoratedDescriptor";
import _initializerWarningHelper from "@babel/runtime/helpers/initializerWarningHelper";

let _Symbol$toStringTag, _Symbol$iterator, _Symbol$asyncIterator, _inspect$custom;

var _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _temp;

import { Readable } from "stream";
import { inspect } from "util";
import { basename } from "path";
import mimes from "mime-types";
import getStreamIterator from "./util/getStreamIterator";
import getLength from "./util/getLength";
import isObject from "./util/isObject";
import isStream from "./util/isStream";
import boundary from "./util/boundary";
import readOnly from "./util/readOnly";
import isBlob from "./util/isBlob";
import toFile from "./util/toFile";
const {
  isBuffer
} = Buffer;
const {
  isArray
} = Array;
const {
  freeze
} = Object;
/**
 * FormData implementation for Node.js.
 *
 * @api public
 */

let FormData = (_class = (_temp = (_Symbol$toStringTag = Symbol.toStringTag, _Symbol$iterator = Symbol.iterator, _Symbol$asyncIterator = Symbol.asyncIterator, _inspect$custom = inspect.custom, class FormData {
  /**
   * Generates a new boundary string once FormData instance constructed
   *
   * @type string
   *
   * @public
   */

  /**
   * Returns headers for multipart/form-data
   *
   * @type object
   *
   * @public
   */

  /**
   * Refers to the internal Readable stream
   *
   * @type stream.Readable
   *
   * @public
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type string
   *
   * @private
   */

  /**
   * @type Map
   *
   * @private
   */

  /**
   * @type AsyncIterableIterator<Buffer>
   *
   * @private
   */

  /**
   * Returns a string representation of the FormData
   *
   * @return {string}
   */
  get [_Symbol$toStringTag]() {
    return "FormData";
  }
  /**
   * @param {array} fields – an optional FormData initial fields.
   *   Each field must be passed as a collection of the objects
   *   with "name", "value" and "filename" props.
   *   See the FormData#append() method for more information.
   */


  constructor(fields = null) {
    _initializerDefineProperty(this, "boundary", _descriptor, this);

    _initializerDefineProperty(this, "headers", _descriptor2, this);

    _initializerDefineProperty(this, "stream", _descriptor3, this);

    _initializerDefineProperty(this, "__carriage", _descriptor4, this);

    _initializerDefineProperty(this, "__dashes", _descriptor5, this);

    _initializerDefineProperty(this, "__footer", _descriptor6, this);

    _initializerDefineProperty(this, "__defaultContentType", _descriptor7, this);

    _initializerDefineProperty(this, "__content", _descriptor8, this);

    _initializerDefineProperty(this, "__curr", _descriptor9, this);

    _defineProperty(this, "__read", () => {
      const onFulfilled = ({
        done,
        value
      }) => {
        if (done) {
          return this.stream.push(null);
        }

        this.stream.push(isBuffer(value) ? value : Buffer.from(String(value)));
      };

      const onRejected = err => this.stream.emit("error", err);

      this.__curr.next().then(onFulfilled).catch(onRejected);
    });

    _defineProperty(this, "inspect", this[inspect.custom]);

    if (isArray(fields)) {
      this.__appendFromInitialFields(fields);
    }
  }
  /**
   * Returns a mime type by field's filename
   *
   * @private
   */


  __getMime(filename) {
    return mimes.lookup(filename) || this.__defaultContentType;
  }
  /**
   * Returns a headers for given field's data
   *
   * @private
   */


  __getHeader(name, filename) {
    let header = "";
    header += `${this.__dashes}${this.boundary}${this.__carriage}`;
    header += `Content-Disposition: form-data; name="${name}"`;

    if (filename) {
      header += `; filename="${filename}"${this.__carriage}`;
      header += `Content-Type: ${this.__getMime(filename)}`;
    }

    return `${header}${this.__carriage.repeat(2)}`;
  }
  /**
   * Get each field from internal Map
   *
   * @private
   */


  async *__getField() {
    for (const [name, {
      values
    }] of this.__content) {
      for (const {
        value,
        filename
      } of values) {
        // Set field's header
        yield this.__getHeader(name, filename);

        if (isBlob(value)) {
          yield* getStreamIterator(value.stream());
        } else if (isStream(value)) {
          // Read the stream content
          yield* getStreamIterator(value);
        } else {
          yield value;
        } // Add trailing carriage


        yield this.__carriage;
      }
    } // Add a footer when all fields ended


    yield this.__footer;
  }
  /**
   * Read values from internal storage and push it to the internal stream
   *
   * @return {void}
   *
   * @private
   */


  /**
   * Append initial fields
   *
   * @param {array} fields
   *
   * @return {void}
   *
   * @private
   */
  __appendFromInitialFields(fields) {
    for (const field of fields) {
      if (isObject(field) && !isArray(field)) {
        this.append(field.name, field.value, field.filename, field.options);
      }
    }
  }
  /**
   * Appends a new value onto an existing key inside a FormData object,
   * or adds the key if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @param {object} [options = {}] An object with additional paramerets.
   *
   * @return {void}
   *
   * @private
   */


  __setField(name, value, filename, options, append, argsLength) {
    const methodName = append ? "append" : "set";

    if (isObject(filename)) {
      [options, filename] = [filename, undefined];
    } // FormData required at least 2 arguments to be set.


    if (argsLength < 2) {
      throw new TypeError(`Failed to execute '${methodName}' on 'FormData': ` + `2 arguments required, but only ${argsLength} present.`);
    } // FormData requires the second argument to be some kind of binary data
    // when a filename has been set.


    if (filename && !(isBlob(value) || isStream(value) || isBuffer(value))) {
      throw new TypeError(`Failed to execute '${methodName}' on 'FormData': ` + "parameter 2 is not one of the following types: ", "ReadableStream | ReadStream | Readable | Buffer | File | Blob");
    } // Get a filename for Buffer, Blob, File, ReadableStream and Readable values


    if (isBuffer(value) && filename) {
      filename = basename(filename);
    } else if (isBlob(value)) {
      filename = basename(value.name || filename || value.constructor.name === "Blob" ? "blob" : String(value.name));
    } else if (isStream(value) && (value.path || filename)) {
      // Readable stream which created from fs.createReadStream
      // have a "path" property. So, we can get a "filename"
      // from the stream itself.
      filename = basename(value.path || filename);
    } // Normalize field content


    if (isStream(value)) {
      if (options.size != null) {
        value = toFile(value, filename || name || options.filename, options);
      }
    } else if (isBlob(value) || isBuffer(value)) {
      value = toFile(value, filename || name || options.filename, options);
    } else {
      value = String(value);
    }

    const field = this.__content.get(name); // Set a new field if given name is not exists


    if (!field) {
      return void this.__content.set(name, {
        append,
        values: [{
          value,
          filename
        }]
      });
    } // Replace a value of the existing field if "set" called


    if (!append) {
      return void this.__content.set(name, {
        append,
        values: [{
          value,
          filename
        }]
      });
    } // Do nothing if the field has been created from .set()


    if (!field.append) {
      return undefined;
    } // Append a new value to the existing field


    field.values.push({
      value,
      filename
    });

    this.__content.set(name, field);
  }
  /**
   * Returns computed length of the FormData content.
   * If data contains stream.Readable field(s),
   * the method will always return undefined.
   *
   * @return {Promise<number | undefined>}
   *
   * @public
   */


  async getComputedLength() {
    let length = 0;

    if (this.__content.size === 0) {
      return length;
    }

    const carriageLength = Buffer.from(this.__carriage).length;

    for (const [name, {
      values
    }] of this.__content) {
      for (const {
        value,
        filename
      } of values) {
        length += Buffer.from(this.__getHeader(name, filename)).length;
        const valueLength = await getLength(value); // Return `undefined` if can't tell field's length
        // (it's probably a stream with unknown length)

        if (valueLength == null) {
          return undefined;
        }

        length += Number(valueLength) + carriageLength;
      }
    }

    return length + Buffer.from(this.__footer).length;
  }
  /**
   * Appends a new value onto an existing key inside a FormData object,
   * or adds the key if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @return {void}
   *
   * @public
   */


  append(name, value, filename = undefined, options = {}) {
    return this.__setField(name, value, filename, options, true, arguments.length);
  }
  /**
   * Set a new value for an existing key inside FormData,
   * or add the new field if it does not already exist.
   *
   * @param {string} name – The name of the field whose data
   *   is contained in value
   *
   * @param {any} value – The field value. You can pass any primitive type
   *   (including null and undefined), Buffer or Readable stream.
   *   Note that Arrays and Object will be converted to string
   *   by using String function.
   *
   * @param {string} [filename = undefined] A filename of given field.
   *   Can be added only for Buffer and Readable
   *
   * @return {void}
   *
   * @public
   */


  set(name, value, filename = undefined, options = {}) {
    return this.__setField(name, value, filename, options, false, arguments.length);
  }
  /**
   * Check if a field with the given name exists inside FormData.
   *
   * @param {string} name – A name of the field you want to test for.
   *
   * @return {boolean}
   *
   * @public
   */


  has(name) {
    return this.__content.has(name);
  }
  /**
   * Returns the first value associated with the given name.
   * Buffer and Readable values will be returned as-is.
   *
   * @param {string} name – A name of the value you want to retrieve.
   *
   * @public
   */


  get(name) {
    const field = this.__content.get(name);

    if (!field) {
      return undefined;
    }

    return field.values[0].value;
  }
  /**
   * Returns all the values associated with
   * a given key from within a FormData object.
   *
   * @param {string} name – A name of the value you want to retrieve.
   *
   * @public
   */


  getAll(name) {
    const field = this.__content.get(name);

    return field ? Array.from(field.values, ({
      value
    }) => value) : [];
  }
  /**
   * Deletes a key and its value(s) from a FormData object.
   *
   * @param {string} name – The name of the key you want to delete.
   *
   * @public
   */


  delete(name) {
    this.__content.delete(name);
  }
  /**
   * @return {IterableIterator<string>}
   */


  *keys() {
    for (const key of this.__content.keys()) {
      yield key;
    }
  }
  /**
   * @return {IterableIterator<[string, any]>}
   */


  *entries() {
    for (const name of this.keys()) {
      const values = this.getAll(name); // Yield each value of a field, like browser-side FormData does.

      for (const value of values) {
        yield [name, value];
      }
    }
  }
  /**
   * @return {IterableIterator<any>}
   */


  *values() {
    for (const [, values] of this) {
      yield values;
    }
  }
  /**
   * @return {IterableIterator<[string, any]>}
   */


  [_Symbol$iterator]() {
    return this.entries();
  }
  /**
   * Executes a given callback for each field of the FormData instance
   *
   * @param {function} fn – Function to execute for each element,
   *   taking three arguments:
   *     + {any} value – A value(s) of the current field.
   *     + {string} – Name of the current field.
   *     + {FormData} fd – The FormData instance that forEach
   *       is being applied to
   *
   * @param {any} [ctx = null]
   *
   * @public
   */


  forEach(fn, ctx = null) {
    for (const [name, value] of this) {
      fn.call(ctx, value, name, this);
    }
  }
  /**
   * This method allows to read a content from internal stream
   * using async generators and for-await-of APIs.
   * An alias of FormData#stream[Symbol.asyncIterator]()
   *
   * @return {AsyncIterableIterator<Buffer>}
   *
   * @public
   */


  [_Symbol$asyncIterator]() {
    return this.stream[Symbol.asyncIterator]();
  }
  /**
   * Alias of the FormData#[util.inspect.custom]()
   *
   * @return {string}
   */


  /**
   * Returns a string representation of the FormData
   *
   * @return {string}
   */
  toString() {
    return "[object FormData]";
  }

  [_inspect$custom]() {
    return "FormData";
  }

}), _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "boundary", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return `NodeJSFormDataStreamBoundary${boundary()}`;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "headers", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return freeze({
      "Content-Type": `multipart/form-data; boundary=${this.boundary}`
    });
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "stream", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return new Readable({
      read: () => this.__read()
    });
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "__carriage", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "\r\n";
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "__dashes", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "-".repeat(2);
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "__footer", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return `${this.__dashes}${this.boundary}${this.__dashes}` + `${this.__carriage.repeat(2)}`;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "__defaultContentType", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return "application/octet-stream";
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "__content", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return new Map();
  }
}), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, "__curr", [readOnly], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function () {
    return this.__getField();
  }
})), _class);
export default FormData;