"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _stream = require("stream");

var _mimeTypes = _interopRequireDefault(require("mime-types"));

var _getStreamIterator = _interopRequireDefault(require("./getStreamIterator"));

var _isBlob = _interopRequireDefault(require("./isBlob"));

const {
  isBuffer
} = Buffer;
/**
 * @api private
 */

class File {
  constructor(content, name, options = {}) {
    this.name = name;
    this.type = options.type || _mimeTypes.default.lookup(name) || "";
    this.size = options.size || 0;
    this.lastModified = options.lastModified || Date.now();
    this.__content = content;
  }

  stream() {
    const content = this.__content;

    if ((0, _isBlob.default)(content)) {
      return content.stream();
    }

    if (isBuffer(content)) {
      const readable = new _stream.Readable({
        read() {}

      });
      readable.push(content);
      readable.push(null);
      return readable;
    }

    return content;
  }

  async arrayBuffer() {
    const iterable = (0, _getStreamIterator.default)(this.stream());
    const chunks = [];

    for await (const chunk of iterable) {
      chunks.push(chunk);
    }

    return Buffer.concat(chunks).buffer;
  }

  toString() {
    return "[object File]";
  }

  get [Symbol.toStringTag]() {
    return "File";
  }

}

var _default = File;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;