"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fs = require("fs");

var _isReadStream = _interopRequireDefault(require("./isReadStream"));

var _isStream = _interopRequireDefault(require("./isStream"));

var _isBlob = _interopRequireDefault(require("./isBlob"));

const {
  isBuffer
} = Buffer;
const {
  stat
} = _fs.promises;
/**
 * Get lenght of given value (in bytes)
 *
 * @param {any} value
 *
 * @return {number | undefined}
 *
 * @api private
 */

async function getLength(value) {
  if ((0, _isStream.default)(value)) {
    if (!(0, _isReadStream.default)(value)) {
      return undefined;
    }

    return stat(value.path).then(({
      size
    }) => size);
  }

  if (isBuffer(value)) {
    return value.length;
  }

  if ((0, _isBlob.default)(value)) {
    return value.size;
  }

  return Buffer.from(String(value)).length;
}

var _default = getLength;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;