"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _readableStreamIterator = _interopRequireDefault(require("./readableStreamIterator"));

var _isWHATWGReadable = _interopRequireDefault(require("./isWHATWGReadable"));

/**
 * Returns stream iterator for given stream-like object
 *
 * @param {Readable | ReadableStream | ReadStream} value
 *
 * @return {AsyncIterableIterator<any>}
 *
 * @api private
 */
function getStreamIterator(value) {
  if ((0, _isWHATWGReadable.default)(value)) {
    return (0, _readableStreamIterator.default)(value.getReader());
  }

  return value;
}

var _default = getStreamIterator;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;