"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const basicTypes = ["null", "number", "object", "array", "string", "function", "undefined", "boolean"];
/**
 * Get a string with type name of the given value
 *
 * @param {any} val
 *
 * @return {string}
 *
 * @api private
 */

function getType(val) {
  const type = Object.prototype.toString.call(val).slice(8, -1);

  if (basicTypes.includes(type.toLowerCase())) {
    return type.toLowerCase();
  }

  return type;
}

var _default = getType;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;