"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isFunction = _interopRequireDefault(require("./isFunction"));

var _isString = _interopRequireDefault(require("./isString"));

var _isObject = _interopRequireDefault(require("./isObject"));

const names = ["Blob", "File"];
/**
 * Check if given valie is Blob or File -like object
 *
 * @param {any} value
 *
 * @return {boolean}
 *
 * @api private
 */

const isBlob = value => (0, _isObject.default)(value) && (0, _isString.default)(value.type) && (0, _isFunction.default)(value.arrayBuffer) && (0, _isFunction.default)(value.stream) && (0, _isFunction.default)(value.constructor) && names.includes(value.constructor.name) && "size" in value;

var _default = isBlob;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;