"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isWHATWGReadable = _interopRequireDefault(require("./isWHATWGReadable"));

var _isReadStream = _interopRequireDefault(require("./isReadStream"));

var _isReadable = _interopRequireDefault(require("./isReadable"));

/**
 * Checks if given value is ONLY fs.ReadStream OR stream.Readable instance
 *
 * @param {any} value
 *
 * @return {boolean}
 *
 * @api private
 */
const isStream = value => (0, _isWHATWGReadable.default)(value) || (0, _isReadStream.default)(value) || (0, _isReadable.default)(value);

var _default = isStream;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;