"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isFunction = _interopRequireDefault(require("./isFunction"));

var _isObject = _interopRequireDefault(require("./isObject"));

/**
 * Check if given value is ReadableStream
 *
 * @param {any} value
 *
 * @return {boolean}
 *
 * @api private
 */
const isWHATWGReadable = value => (0, _isObject.default)(value) && (0, _isFunction.default)(value.cancel) && (0, _isFunction.default)(value.getReader) && (0, _isFunction.default)(value.pipeTo) && (0, _isFunction.default)(value.pipeThrough) && (0, _isFunction.default)(value.constructor) && value.constructor.name === "ReadableStream";

var _default = isWHATWGReadable;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;