"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * Reads a content from given ReadableStream
 *
 * @yield {any}
 *
 * @api private
 */
async function* readableStreamIterator(reader) {
  while (true) {
    const {
      done,
      value
    } = await reader.read();

    if (done) {
      return value;
    }

    yield value;
  }
}

var _default = readableStreamIterator;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;