"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isBlob = _interopRequireDefault(require("./isBlob"));

var _File = _interopRequireDefault(require("./File"));

const {
  isBuffer
} = Buffer;
/**
 * @api private
 */

function toFile(value, name, options = {}) {
  if (value.constructor.name === "File") {
    return value;
  }

  if (isBuffer(value)) {
    options.size = value.length;
  } else if ((0, _isBlob.default)(value)) {
    options.type = value.type || options.type;
    options.size = value.size == null ? options.size : value.size;
    options.lastModified = value.lastModified == null ? options.lastModified : value.lastModified;
  }

  return new _File.default(value, name, options);
}

var _default = toFile;
exports.default = _default;
module.exports = exports.default;
module.exports.default = exports.default;