var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _FormData_instances, _FormData_entries, _FormData_setEntry;
import { inspect } from "util";
import { File } from "./File.js";
import { isFile } from "./isFile.js";
import normalizeFilename from "./normalizeFilename.js";
export class FormData {
    constructor(entries) {
        _FormData_instances.add(this);
        _FormData_entries.set(this, new Map());
        if (entries) {
            entries.forEach(({ name, value, fileName }) => this.append(name, value, fileName));
        }
    }
    append(name, value, fileName) {
        return __classPrivateFieldGet(this, _FormData_instances, "m", _FormData_setEntry).call(this, {
            name,
            value,
            fileName,
            append: true,
            argsLength: arguments.length
        });
    }
    set(name, value, fileName) {
        return __classPrivateFieldGet(this, _FormData_instances, "m", _FormData_setEntry).call(this, {
            name,
            value,
            fileName,
            append: false,
            argsLength: arguments.length
        });
    }
    get(name) {
        const field = __classPrivateFieldGet(this, _FormData_entries, "f").get(String(name));
        if (!field) {
            return null;
        }
        return field[0];
    }
    getAll(name) {
        const field = __classPrivateFieldGet(this, _FormData_entries, "f").get(String(name));
        if (!field) {
            return [];
        }
        return field.slice();
    }
    has(name) {
        return __classPrivateFieldGet(this, _FormData_entries, "f").has(String(name));
    }
    delete(name) {
        return void __classPrivateFieldGet(this, _FormData_entries, "f").delete(String(name));
    }
    *keys() {
        for (const key of __classPrivateFieldGet(this, _FormData_entries, "f").keys()) {
            yield key;
        }
    }
    *entries() {
        for (const name of this.keys()) {
            const values = this.getAll(name);
            for (const value of values) {
                yield [name, value];
            }
        }
    }
    *values() {
        for (const [, value] of this) {
            yield value;
        }
    }
    [(_FormData_entries = new WeakMap(), _FormData_instances = new WeakSet(), _FormData_setEntry = function _FormData_setEntry({ name, value, append, fileName, argsLength }) {
        const methodName = append ? "append" : "set";
        name = String(name);
        if (argsLength < 2) {
            throw new TypeError(`Failed to execute '${methodName}' on 'FormData': `
                + `2 arguments required, but only ${argsLength} present.`);
        }
        let normalizedValue;
        if (isFile(value)) {
            fileName = normalizeFilename(fileName === undefined ? value.name : fileName);
            normalizedValue = new File([value], fileName, {
                type: value.type,
                lastModified: value.lastModified
            });
        }
        else if (fileName) {
            throw new TypeError(`Failed to execute '${methodName}' on 'FormData': `
                + "parameter 2 is not of type 'Blob'.");
        }
        else {
            normalizedValue = String(value);
        }
        const values = __classPrivateFieldGet(this, _FormData_entries, "f").get(name);
        if (!values) {
            return void __classPrivateFieldGet(this, _FormData_entries, "f").set(name, [normalizedValue]);
        }
        if (!append) {
            return void __classPrivateFieldGet(this, _FormData_entries, "f").set(name, [normalizedValue]);
        }
        values.push(normalizedValue);
    }, Symbol.iterator)]() {
        return this.entries();
    }
    forEach(fn, ctx) {
        for (const [name, value] of this) {
            fn.call(ctx, value, name, this);
        }
    }
    get [Symbol.toStringTag]() {
        return "FormData";
    }
    [inspect.custom]() {
        return this[Symbol.toStringTag];
    }
}
