import { File, FilePropertyBag } from "./File";
export * from "./isFile";
export declare type FileFromPathOptions = Omit<FilePropertyBag, "lastModified">;
/**
 * Creates a `File` referencing the one on a disk by given path. Synchronous version of the `fileFromPath`
 *
 * @param path Path to read a file from
 * @param filename Optional file name. If not presented, the path will be used to get it
 * @param options File options
 */
export declare function fileFromPathSync(path: string): File;
export declare function fileFromPathSync(path: string, filename?: string): File;
export declare function fileFromPathSync(path: string, options?: FileFromPathOptions): File;
export declare function fileFromPathSync(path: string, filename?: string, options?: FileFromPathOptions): File;
/**
 * Creates a `File` referencing the one on a disk by given path.
 *
 * @param path Path to read a file from
 * @param filename Optional file name. If not presented, the path will be used to get it
 * @param options File options
 */
export declare function fileFromPath(path: string): Promise<File>;
export declare function fileFromPath(path: string, filename?: string): Promise<File>;
export declare function fileFromPath(path: string, options?: FileFromPathOptions): Promise<File>;
export declare function fileFromPath(path: string, filename?: string, options?: FileFromPathOptions): Promise<File>;
