"use strict";

require("core-js/modules/es.array.concat");

require("core-js/modules/es.string.trim");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _nativePromiseOnly = _interopRequireDefault(require("native-promise-only"));

var _xhr = _interopRequireDefault(require("./xhr"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var s3 = function s3(formio) {
  return {
    uploadFile: function uploadFile(file, fileName, dir, progressCallback) {
      return _xhr.default.upload(formio, 's3', function (xhr, response) {
        response.data.fileName = fileName;
        response.data.key = _xhr.default.path([response.data.key, dir, fileName]);

        if (response.signed) {
          xhr.open('PUT', response.signed);
          xhr.setRequestHeader('Content-Type', file.type);
          return file;
        } else {
          var fd = new FormData();

          for (var key in response.data) {
            fd.append(key, response.data[key]);
          }

          fd.append('file', file);
          xhr.open('POST', response.url);
          return fd;
        }
      }, file, fileName, dir, progressCallback).then(function (response) {
        return {
          storage: 's3',
          name: fileName,
          bucket: response.bucket,
          key: response.data.key,
          url: _xhr.default.path([response.url, response.data.key]),
          acl: response.data.acl,
          size: file.size,
          type: file.type
        };
      });
    },
    downloadFile: function downloadFile(file) {
      if (file.acl !== 'public-read') {
        return formio.makeRequest('file', "".concat(formio.formUrl, "/storage/s3?bucket=").concat(_xhr.default.trim(file.bucket), "&key=").concat(_xhr.default.trim(file.key)), 'GET');
      } else {
        return _nativePromiseOnly.default.resolve(file);
      }
    }
  };
};

s3.title = 'S3';
var _default = s3;
exports.default = _default;