/**
 * The official FormKit internationalization (i18n) plugin. This package
 * contains the locales and the plugin that integrates FormKit with these
 * locales. Read the {@link https://formkit.com/essentials/internationalization
 * | internationalization documentation} for usage instructions.
 *
 * @packageDocumentation
 */

import { FormKitPlugin } from '@formkit/core';
import { FormKitValidationMessages } from '@formkit/validation';

declare namespace ar {
    export {
        ui,
        validation
    }
}
export { ar }

declare namespace az {
    export {
        ui_2 as ui,
        validation_2 as validation
    }
}
export { az }

declare namespace bg {
    export {
        ui_3 as ui,
        validation_3 as validation
    }
}
export { bg }

declare namespace bs {
    export {
        ui_4 as ui,
        validation_4 as validation
    }
}
export { bs }

declare namespace ca {
    export {
        ui_5 as ui,
        validation_5 as validation
    }
}
export { ca }

/**
 * Create a new internationalization plugin for FormKit.
 *
 * @param registry - The registry of {@link @formkit/i18n#FormKitLocaleRegistry | FormKitLocales}.
 *
 * @returns {@link @formkit/core#FormKitPlugin | FormKitPlugin}
     *
     * @public
     */
 export declare function createI18nPlugin(registry: FormKitLocaleRegistry): FormKitPlugin;

 declare namespace cs {
     export {
         ui_6 as ui,
         validation_6 as validation
     }
 }
 export { cs }

 declare namespace da {
     export {
         ui_7 as ui,
         validation_7 as validation
     }
 }
 export { da }

 /**
  * Given a string or a date, return a nice human-readable version.
  *
  * @param date - A string or a date.
  *
  * @returns `string`
  *
  * @public
  */
 export declare function date(date: string | Date): string;

 declare namespace de {
     export {
         ui_8 as ui,
         validation_8 as validation
     }
 }
 export { de }

 declare namespace el {
     export {
         ui_9 as ui,
         validation_9 as validation
     }
 }
 export { el }

 declare namespace en {
     export {
         ui_10 as ui,
         validation_10 as validation
     }
 }
 export { en }

 declare namespace es {
     export {
         ui_11 as ui,
         validation_11 as validation
     }
 }
 export { es }

 declare namespace fa {
     export {
         ui_12 as ui,
         validation_12 as validation
     }
 }
 export { fa }

 declare namespace fi {
     export {
         ui_13 as ui,
         validation_13 as validation
     }
 }
 export { fi }

 /**
  * A locale is just a collection of locale message registries, they are keyed
  * by the type (like a namespace) ex: "validation" or "ui". Plugin authors
  * can declare their own types too.
  *
  * @public
  */
 export declare interface FormKitLocale {
     ui: FormKitLocaleMessages;
     [index: string]: FormKitLocaleMessages;
 }

 /**
  * Note: We are choosing not to implement via Intl.Locale because the support is
  * not yet good enough to be used without polyfill consideration, and that
  * polyfill is 36.3Kb min + gzip — larger than all of FormKit.
  *
  * https://formatjs.io/docs/polyfills/intl-locale/
  *
  * Instead we use a very minimal solution that should provide very good support
  * for all users, and we're happy to expand this package if we see areas where
  * localization is not quite good enough. Also, once support for Intl.Locale
  * becomes better, we would expect this package to switch much of it's
  * underlying locale parsing logic to nose native APIs.
  */
 /**
  * A registry of locale messages — this is simply a keyed/value object with
  * string keys (message name) and either string values (for simple returns) or
  * functions that receive a context object.
  *
  * @public
  */
 export declare interface FormKitLocaleMessages {
     [index: string]: string | ((...args: any[]) => string);
 }

 /**
  * The locale registry is just a key-value pair of locale indexes ('ar', 'en',
  * 'it', etc.) to their respective locales.
  *
  * @public
  */
 export declare interface FormKitLocaleRegistry {
     [index: string]: FormKitLocale;
 }

 declare namespace fr {
     export {
         ui_14 as ui,
         validation_14 as validation
     }
 }
 export { fr }

 declare namespace fy {
     export {
         ui_15 as ui,
         validation_15 as validation
     }
 }
 export { fy }

 declare namespace he {
     export {
         ui_16 as ui,
         validation_16 as validation
     }
 }
 export { he }

 declare namespace hr {
     export {
         ui_17 as ui,
         validation_17 as validation
     }
 }
 export { hr }

 declare namespace hu {
     export {
         ui_18 as ui,
         validation_18 as validation
     }
 }
 export { hu }

 declare namespace id {
     export {
         ui_19 as ui,
         validation_19 as validation
     }
 }
 export { id }

 declare namespace is {
     export {
         ui_45 as ui,
         validation_45 as validation
     }
 }
 export { is }

 declare namespace it {
     export {
         ui_20 as ui,
         validation_20 as validation
     }
 }
 export { it }

 declare namespace ja {
     export {
         ui_21 as ui,
         validation_21 as validation
     }
 }
 export { ja }

 declare namespace kk {
     export {
         ui_22 as ui,
         validation_22 as validation
     }
 }
 export { kk }

 declare namespace ko {
     export {
         ui_23 as ui,
         validation_23 as validation
     }
 }
 export { ko }

 /**
  * Creates an oxford-comma separated list of items.
  *
  * @param items - the items to list out.
  * @param conjunction - in the list "x, y, and z", "and" is the conjunction.
  * Defaults to "or".
  *
  * @returns `string`
  *
  * @public
  */
 export declare function list(items: string[], conjunction?: string): string;

 /**
  * Export all the available locales at once.
  *
  * @public
  */
 export declare const locales: {
     ar: typeof ar;
     az: typeof az;
     bg: typeof bg;
     bs: typeof bs;
     ca: typeof ca;
     cs: typeof cs;
     da: typeof da;
     de: typeof de;
     el: typeof el;
     en: typeof en;
     es: typeof es;
     fa: typeof fa;
     fi: typeof fi;
     fr: typeof fr;
     fy: typeof fy;
     he: typeof he;
     hr: typeof hr;
     hu: typeof hu;
     id: typeof id;
     it: typeof it;
     ja: typeof ja;
     kk: typeof kk;
     ko: typeof ko;
     lt: typeof lt;
     lv: typeof lv;
     nb: typeof nb;
     nl: typeof nl;
     pl: typeof pl;
     pt: typeof pt;
     ro: typeof ro;
     ru: typeof ru;
     sk: typeof sk;
     sl: typeof sl;
     sr: typeof sr;
     sv: typeof sv;
     tet: typeof tet;
     tg: typeof tg;
     th: typeof th;
     tr: typeof tr;
     uk: typeof uk;
     uz: typeof uz;
     vi: typeof vi;
     zh: typeof zh;
     'zh-TW': typeof zhTW;
     is: typeof is;
     mn: typeof mn;
 };

 declare namespace lt {
     export {
         ui_24 as ui,
         validation_24 as validation
     }
 }
 export { lt }

 declare namespace lv {
     export {
         ui_25 as ui,
         validation_25 as validation
     }
 }
 export { lv }

 declare namespace mn {
     export {
         ui_46 as ui,
         validation_46 as validation
     }
 }
 export { mn }

 declare namespace nb {
     export {
         ui_26 as ui,
         validation_26 as validation
     }
 }
 export { nb }

 declare namespace nl {
     export {
         ui_27 as ui,
         validation_27 as validation
     }
 }
 export { nl }

 /**
  * Orders two variables from smallest to largest.
  *
  * @param first - The first number or string.
  * @param second - The second number or string.
  *
  * @returns `[smaller: number | string, larger: number | string]`
  *
  * @public
  */
 export declare function order(first: string | number, second: string | number): [smaller: number | string, larger: number | string];

 declare namespace pl {
     export {
         ui_28 as ui,
         validation_28 as validation
     }
 }
 export { pl }

 declare namespace pt {
     export {
         ui_29 as ui,
         validation_29 as validation
     }
 }
 export { pt }

 declare namespace ro {
     export {
         ui_30 as ui,
         validation_30 as validation
     }
 }
 export { ro }

 declare namespace ru {
     export {
         ui_31 as ui,
         validation_31 as validation
     }
 }
 export { ru }

 /**
  * Given a string, convert it to sentence case.
  *
  * @param str - The string to sentence case.
  *
  * @returns `string`
  *
  * @public
  */
 export declare function sentence(str: string): string;

 declare namespace sk {
     export {
         ui_32 as ui,
         validation_32 as validation
     }
 }
 export { sk }

 declare namespace sl {
     export {
         ui_33 as ui,
         validation_33 as validation
     }
 }
 export { sl }

 declare namespace sr {
     export {
         ui_34 as ui,
         validation_34 as validation
     }
 }
 export { sr }

 declare namespace sv {
     export {
         ui_35 as ui,
         validation_35 as validation
     }
 }
 export { sv }

 declare namespace tet {
     export {
         ui_36 as ui,
         validation_36 as validation
     }
 }
 export { tet }

 declare namespace tg {
     export {
         ui_37 as ui,
         validation_37 as validation
     }
 }
 export { tg }

 declare namespace th {
     export {
         ui_38 as ui,
         validation_38 as validation
     }
 }
 export { th }

 declare namespace tr {
     export {
         ui_39 as ui,
         validation_39 as validation
     }
 }
 export { tr }

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_10: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_11: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_12: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_13: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_14: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_15: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_16: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_17: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_18: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_19: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_2: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_20: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_21: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_22: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_23: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_24: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_25: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_26: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_27: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_28: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_29: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_3: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_30: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_31: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_32: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_33: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_34: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_35: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_36: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_37: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_38: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_39: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_4: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_40: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_41: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_42: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_43: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_44: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_45: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_46: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_5: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_6: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_7: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_8: FormKitLocaleMessages;

 /**
  * Standard language for interface features.
  * @public
  */
 declare const ui_9: FormKitLocaleMessages;

 declare namespace uk {
     export {
         ui_40 as ui,
         validation_40 as validation
     }
 }
 export { uk }

 declare namespace uz {
     export {
         ui_41 as ui,
         validation_41 as validation
     }
 }
 export { uz }

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_10: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_11: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_12: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_13: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_14: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_15: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_16: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_17: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_18: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_19: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_2: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_20: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_21: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_22: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_23: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_24: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_25: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_26: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_27: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_28: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_29: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_3: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_30: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_31: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_32: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_33: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_34: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_35: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_36: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_37: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_38: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_39: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_4: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_40: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_41: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_42: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_43: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_44: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_45: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_46: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_5: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_6: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_7: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_8: FormKitValidationMessages;

 /**
  * These are all the possible strings that pertain to validation messages.
  * @public
  */
 declare const validation_9: FormKitValidationMessages;

 declare namespace vi {
     export {
         ui_42 as ui,
         validation_42 as validation
     }
 }
 export { vi }

 declare namespace zh {
     export {
         ui_43 as ui,
         validation_43 as validation
     }
 }
 export { zh }

 declare namespace zhTW {
     export {
         ui_44 as ui,
         validation_44 as validation
     }
 }
 export { zhTW }

 export { }
