<p align="center">
  <a href="https://www.formkit.com#gh-light-mode-only" target="_blank" rel="noopener noreferrer"><img width="200" src="https://cdn.formk.it/brand-assets/formkit-logo.png" alt="FormKit Logo"></a>
  <a href="https://www.formkit.com#gh-dark-mode-only" target="_blank" rel="noopener noreferrer"><img width="200" src="https://cdn.formk.it/brand-assets/formkit-logo-white.png" alt="FormKit Logo"></a>
</p>

<p align="center">
  <a href="https://github.com/formkit/formkit/actions"><img title="Build Badge" alt="GitHub Build Status" src="https://github.com/formkit/formkit/actions/workflows/tests.yml/badge.svg"></a>
  <a href="https://www.npmjs.com/package/@formkit/vue"><img alt="npm" src="https://img.shields.io/npm/v/@formkit/vue"></a>
  <a href="https://github.com/formkit/formkit"><img alt="GitHub" src="https://img.shields.io/github/license/formkit/formkit"></a>
</p>

<p align="center">
  <a href="https://formkit.com">Documentation website</a>
</p>

# FormKit (Beta)
<h2><img width="20" style="vertical-align:middle;" src="https://cdn.formk.it/vendor-logos/vue-logo.png"> Vue 3 form development. 10x faster.</h2>

FormKit is a form-authoring framework for Vue developers that makes building high quality production-ready forms 10x
faster. It is easy-to-learn and ships with production-ready scaffolding like inputs, forms, submission and error
handling, and validation rules. To learn more check out the documentation website at: [formkit.com](https://www.formkit.com).

<p align="center"><a href="https://formkit.com"><img width="190" src="https://cdn.formk.it/web-assets/read-the-docs.svg" /></a></p>

## Sponsors

FormKit — which supports its whole feature set for _native HTML inputs_ (like `select`, `checkbox`, and `textarea`) — is and will always be an MIT-licensed
open source project. Please consider [sponsoring FormKit](https://github.com/sponsors/formkit) so we can sustainably
and continually improve it! There are a variety of sponsor tiers and benefits for each sponsor.

### 🥉 Bronze sponsors

<p style="margin-bottom: 1em;">
  <a href="https://www.perbyte.com">
    <img src="https://cdn.formk.it/web-assets/sponsors/bronze-sponsor_perbyte.png" alt="PerByte logo" width="200">
  </a>
</p>


### Backers

[uscreen](https://uscreen.de)

<table style="width: 100%;">
	<tr>
		<th colspan="2">
			<h2>Key features</h3>
		</th>
	<tr>
	<tr>
    <td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em;">☝️ Comprehensive package</h4>
			<p>FormKit is an all-in-one form-authoring framework with <a href="https://formkit.com/essentials/inputs">input scaffolding</a> (labels, help text, etc.), <a href="https://formkit.com/essentials/validation">validation</a>, form <a href="https://formkit.com/essentials/styling">UI & styling</a>, <a href="https://formkit.com/essentials/forms">error handling</a>,   <a href="https://formkit.com/essentials/schema">generation</a>, a11y, <a href="https://formkit.com/essentials/internationalization">i18n</a>, and more! </p>
		</td>
		<td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em">😎 Developer happiness</h4>
			<p>Forms are everywhere, yet surprisingly tedious to author — well, not anymore. FormKit provides a <a href="https://formkit.com/essentials/inputs#props--attributes">powerful and flexible API</a> to developers that makes complex form creation a breeze.</p>
		</td>
	</tr>
	<tr>
    <td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em;">🎯 Validation built in</h4>
			<p>Ridiculously easy <a href="https://formkit.com/essentials/validation">validation</a> out-of-the-box to handle 95% of use-cases. Help text, validation rules, and validation messages are simple props. Need more? You can add <a href="https://formkit.com/essentials/validation#custom-rules">custom validation rules</a> too.</p>
		</td>
		<td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em">⚡️ Blazing-fast Performance</h4>
			<p>FormKit can handle the most demanding forms — wizards, multi-step, deeply nested repeating groups, and more.</p>
		</td>
	</tr>
	<tr>
		<td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em">🔌 Plugin system</h4>
			<p>Extend FormKit's functionality or reuse custom inputs, validation rules and messages across projects by tapping into the <a href="https://formkit.com/advanced/core#plugins">plugin system</a>. Make your plugin open source to share with others!</p>
		</td>
		<td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em;">✨ Generate forms</h4>
			<p><a href="https://formkit.com/essentials/schema">Generate an entire form</a> from a JSON-compatible schema. Schema allows you to render complex forms from JSON with conditional rendering, logic, dynamic data, groups, wrappers, HTML elements, and custom components.</p>
		</td>
	</tr>
  <tr>
		<td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em">🎨 Robust Theming</h4>
			<p>FormKit works easily alongside your favorite UI frameworks like Bootstrap and utility-class tools like Tailwind. With numerous ways to <a href="https://formkit.com/essentials/styling#custom-classes">modify classes</a> and <a href="https://formkit.com/essentials/inputs#schema-overrides">DOM structure</a>, integrating FormKit plays nicely with any frontend.</p>
		</td>
    <td style="width: 50%; vertical-align: top;">
			<h4 style="margin-top: 0.25em">🌐 Internationalization</h4>
			<p>FormKit is made for all! Thanks to the FormKit community, FormKit ships with support for <a href="https://formkit.com/essentials/internationalization">many languages</a>. Don't see your language? Contribute one with our <a href="https://i18n.formkit.com">locale builder.</a></p>
		</td>
	</tr>

</table>

## Contributing
Thank you for your willingness to contribute to this free and open source project! When contributing, consider first discussing your desired change with the core team via [GitHub issues](https://github.com/formkit/formkit/issues), [Discord](https://discord.gg/Vhu97pAC76), or other method.


### Contributors

This project exists thanks to all the people who volunteer their time to contribute!

<a href="https://github.com/formkit/formkit/graphs/contributors"><img src="https://contributors-img.web.app/image?repo=formkit/formkit" /></a>

## License

[MIT](https://opensource.org/licenses/MIT)

Copyright (c) 2021-present, [FormKit, Inc.](https://formkit.com)
