import { AllowedComponentProps } from 'vue';
import { App } from 'vue';
import { clearErrors } from '@formkit/core';
import { Component } from 'vue';
import { ComponentCustomProps } from 'vue';
import { ComponentOptionsMixin } from 'vue';
import { DefineComponent } from 'vue';
import { errorHandler } from '@formkit/core';
import { ExtractPropTypes } from 'vue';
import { FormKitEvents } from '@formkit/inputs';
import { FormKitIconLoader } from '@formkit/themes';
import { FormKitIconLoaderUrl } from '@formkit/themes';
import { FormKitInputs } from '@formkit/inputs';
import { FormKitInputSlots } from '@formkit/inputs';
import { FormKitLibrary } from '@formkit/core';
import { FormKitLocale } from '@formkit/i18n';
import { FormKitLocaleRegistry } from '@formkit/i18n';
import { FormKitNode } from '@formkit/core';
import { FormKitOptions } from '@formkit/core';
import { FormKitPlugin } from '@formkit/core';
import { FormKitRootConfig } from '@formkit/core';
import { FormKitSchemaCondition } from '@formkit/core';
import { FormKitSchemaDefinition } from '@formkit/core';
import { FormKitSchemaNode } from '@formkit/core';
import { FormKitSection } from '@formkit/inputs';
import { FormKitTypeDefinition } from '@formkit/core';
import { FormKitValidationRule } from '@formkit/validation';
import { InjectionKey } from 'vue';
import { InputType } from '@formkit/inputs';
import type { Plugin as Plugin_2 } from 'vue';
import { PropType } from 'vue';
import { Ref } from 'vue';
import { RendererElement } from 'vue';
import { RendererNode } from 'vue';
import { reset } from '@formkit/core';
import { resetCount } from '@formkit/core';
import { setErrors } from '@formkit/core';
import { SetupContext } from 'vue';
import { submitForm } from '@formkit/core';
import { VNode } from 'vue';
import { VNodeProps } from 'vue';

/**
 * A plugin that creates Vue-specific context object on each given node.
 *
 * @param node - FormKitNode to create the context on.
 *
 * @public
 */
export declare const bindings: FormKitPlugin;

export { clearErrors }

declare interface ConfigLoaderProps {
    defaultConfig?: boolean;
    configFile?: string;
}

/**
 * The symbol key for accessing FormKit root configuration.
 *
 * @public
 */
export declare const configSymbol: InjectionKey<FormKitRootConfig>;

/**
 * Creates a new input from schema or a Vue component with the "standard"
 * FormKit features in place such as labels, help text, validation messages, and
 * class support.
 *
 * @param schemaOrComponent - The actual schema of the input or the component.
 * @param definitionOptions - Any options in the FormKitTypeDefinition you want
 * to define.
 *
 * @returns {@link @formkit/core#FormKitTypeDefinition | FormKitTypeDefinition}
     *
     * @public
     */
 export declare function createInput(schemaOrComponent: FormKitSchemaNode | FormKitSection | Component, definitionOptions?: Partial<FormKitTypeDefinition>): FormKitTypeDefinition;

 /**
  * Default configuration options. Includes all validation rules,
  * en i18n messages.
  *
  * @public
  */
 export declare const defaultConfig: (options?: DefaultConfigOptions) => FormKitOptions;

 /**
  * The allowed options for defaultConfig.
  *
  * @public
  */
 export declare type DefaultConfigOptions = FormKitOptions & Partial<PluginConfigs> & Record<string, unknown>;

 export declare function defineFormKitConfig(config: DefaultConfigOptions | (() => DefaultConfigOptions)): () => DefaultConfigOptions;

 export { errorHandler }

 /**
  * The root FormKit component. Use it to craft all inputs and structure of your
  * forms. For example:
  *
  * ```vue
  * <FormKit
  *  type="text"
  *  label="Name"
  *  help="Please enter your name"
  *  validation="required|length:2"
  * />
  * ```
  *
  * @public
  */
 export declare const FormKit: FormKitComponent;

 /**
  * The TypeScript definition for the FormKit component.
  * @public
  */
 export declare type FormKitComponent = <Props extends FormKitInputs<Props>>(props: Props & VNodeProps & AllowedComponentProps & ComponentCustomProps, context?: Pick<FormKitSetupContext<Props>, 'attrs' | 'emit' | 'slots'>, setup?: FormKitSetupContext<Props>) => VNode<RendererNode, RendererElement, {
     [key: string]: any;
 }> & {
     __ctx?: FormKitSetupContext<Props>;
 };

 /**
  * A library of components available to the schema (in addition to globally
  * registered ones)
  *
  * @public
  */
 export declare interface FormKitComponentLibrary {
     [index: string]: Component;
 }

 /**
  * Renders an icon using the current IconLoader set at the root FormKit config
  *
  * @public
  */
 export declare const FormKitIcon: DefineComponent<    {
 icon: {
 type: StringConstructor;
 default: string;
 };
 iconLoader: {
 type: PropType<FormKitIconLoader>;
 default: null;
 };
 iconLoaderUrl: {
 type: PropType<(iconName: string) => string>;
 default: null;
 };
 }, () => VNode<RendererNode, RendererElement, {
 [key: string]: any;
 }> | null, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<    {
 icon: {
 type: StringConstructor;
 default: string;
 };
 iconLoader: {
 type: PropType<FormKitIconLoader>;
 default: null;
 };
 iconLoaderUrl: {
 type: PropType<(iconName: string) => string>;
 default: null;
 };
 }>>, {
 icon: string;
 iconLoader: FormKitIconLoader;
 iconLoaderUrl: (iconName: string) => string;
 }, {}>;

 /**
  * Renders FormKit components fetched from a remote schema repository.
  * This is a kitchen sink component that is used for testing purposes.
  * It shows inputs in various states and configurations.
  *
  * @public
  */
 export declare const FormKitKitchenSink: DefineComponent<    {
 pro: {
 type: BooleanConstructor;
 default: boolean;
 };
 schemas: {
 type: ArrayConstructor;
 required: false;
 };
 }, () => VNode<RendererNode, RendererElement, {
 [key: string]: any;
 }>, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<    {
 pro: {
 type: BooleanConstructor;
 default: boolean;
 };
 schemas: {
 type: ArrayConstructor;
 required: false;
 };
 }>>, {
 pro: boolean;
 }, {}>;

 /**
  * The FormKitLazyProvider component performs 2 HOC functions:
  *
  * 1. It checks if a FormKit config has already been provided, if it has it will
  *   render the children immediately.
  * 2. If a config has not been provided, it will render a Suspense component
  *    which will render the children once the config has been loaded by using
  *    the FormKitConfigLoader component.
  *
  * @public
  */
 export declare const FormKitLazyProvider: (props: ConfigLoaderProps & {}) => any;

 /**
  * Renders the messages for a parent node, or any node explicitly passed to it.
  * @public
  */
 export declare const FormKitMessages: DefineComponent<    {
 node: {
 type: PropType<FormKitNode> | undefined;
 required: false;
 };
 sectionsSchema: {
 type: PropType<Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>>;
 default: {};
 };
 defaultPosition: {
 type: PropType<boolean | "true" | "false" | undefined>;
 default: boolean;
 };
 }, () => VNode<RendererNode, RendererElement, {
 [key: string]: any;
 }> | null, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<    {
 node: {
 type: PropType<FormKitNode> | undefined;
 required: false;
 };
 sectionsSchema: {
 type: PropType<Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>>;
 default: {};
 };
 defaultPosition: {
 type: PropType<boolean | "true" | "false" | undefined>;
 default: boolean;
 };
 }>>, {
 sectionsSchema: Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>;
 defaultPosition: boolean | "true" | "false" | undefined;
 }, {}>;

 /**
  * The FormKitProvider component provides the FormKit config to the children.
  *
  * @public
  */
 export declare const FormKitProvider: (props: {
     config: any;
 } & {}) => any;

 /**
  * The FormKitRoot wrapper component used to provide context to FormKit about
  * whether a FormKit input is booting in a Document or ShadowRoot. This is
  * generally only necessary when booting FormKit nodes in contexts that do not
  * have a document. For example, if running code like this:
  *
  * ```ts
  * document.getElementById(node.props.id)
  * ```
  *
  * does not work because the `document` is not available or is not in the same
  * scope, you can place a `<FormKitRoot>` component somewhere near the root of
  * of your shadowRoot and it will inform any FormKitNode child (at any depth)
  * that it is running in a shadow root. The "root" (`Document` or `ShadowRoot`)
  * will be made available to all child nodes at `node.context._root`
  *
  * @public
  */
 export declare const FormKitRoot: (props: Record<string, any> & {}) => any;

 /**
  * The FormKitSchema vue component:
  *
  * @public
  */
 export declare const FormKitSchema: DefineComponent<    {
 schema: {
 type: PropType<FormKitSchemaDefinition>;
 required: true;
 };
 data: {
 type: PropType<Record<string, any>>;
 default: () => {};
 };
 library: {
 type: PropType<FormKitComponentLibrary>;
 default: () => {};
 };
 memoKey: {
 type: StringConstructor;
 required: false;
 };
 }, () => string | number | boolean | VirtualNode | (Renderable | Renderable[])[] | RenderableSlots | null, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {}, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<    {
 schema: {
 type: PropType<FormKitSchemaDefinition>;
 required: true;
 };
 data: {
 type: PropType<Record<string, any>>;
 default: () => {};
 };
 library: {
 type: PropType<FormKitComponentLibrary>;
 default: () => {};
 };
 memoKey: {
 type: StringConstructor;
 required: false;
 };
 }>>, {
 data: Record<string, any>;
 library: FormKitComponentLibrary;
 }, {}>;

 /**
  * Type definition for the FormKit component Vue context.
  * @public
  */
 export declare interface FormKitSetupContext<Props extends FormKitInputs<Props>> {
     props: {} & Props;
     expose(exposed: {}): void;
     attrs: any;
     slots: Slots<Props>;
     emit: FormKitEvents<Props>;
 }

 /**
  * Renders the messages for a parent node, or any node explicitly passed to it.
  * @public
  */
 export declare const FormKitSummary: DefineComponent<    {
 node: {
 type: PropType<FormKitNode> | undefined;
 required: false;
 };
 sectionsSchema: {
 type: PropType<Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>>;
 default: {};
 };
 }, () => VNode<RendererNode, RendererElement, {
 [key: string]: any;
 }> | null, unknown, {}, {}, ComponentOptionsMixin, ComponentOptionsMixin, {
 show: (_summaries: Array<FormKitSummaryMessage>) => boolean;
 }, string, VNodeProps & AllowedComponentProps & ComponentCustomProps, Readonly<ExtractPropTypes<    {
 node: {
 type: PropType<FormKitNode> | undefined;
 required: false;
 };
 sectionsSchema: {
 type: PropType<Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>>;
 default: {};
 };
 }>> & {
 onShow?: ((_summaries: FormKitSummaryMessage[]) => any) | undefined;
 }, {
 sectionsSchema: Record<string, FormKitSchemaCondition | Partial<FormKitSchemaNode>>;
 }, {}>;

 export declare interface FormKitSummaryMessage {
     message: string;
     id: string;
     key: string;
     type: string;
 }

 /**
  * The global instance of the FormKit plugin.
  *
  * @public
  */
 export declare interface FormKitVuePlugin {
     get: (id: string) => FormKitNode | undefined;
     setLocale: (locale: string) => void;
     setErrors: (formId: string, errors: string[] | Record<string, string | string[]>, inputErrors?: string[] | Record<string, string | string[]>) => void;
     clearErrors: (formId: string) => void;
     submit: (formId: string) => void;
     reset: (formId: string, resetTo?: unknown) => void;
 }

 /**
  * Returns the node that is currently having its schema created.
  *
  * @public
  */
 export declare const getCurrentSchemaNode: () => FormKitNode | null;

 /**
  * Register a callback for when SSR is complete. No-op if not in a server
  * context.
  * @param app - The Vue application.
  * @param callback - The callback to be called after SSR is complete.
  * @public
  */
 export declare function onSSRComplete(app: App<any> | undefined, callback: CallableFunction): void;

 /**
  * The symbol key for accessing the FormKit node options.
  *
  * @public
  */
 export declare const optionsSymbol: InjectionKey<FormKitOptions>;

 /**
  * The symbol that represents the formkit parent injection value.
  *
  * @public
  */
 export declare const parentSymbol: InjectionKey<FormKitNode>;

 /**
  * Create the FormKit plugin.
  *
  * @public
  */
 export declare const plugin: Plugin_2;

 /**
  * Configuration for plugins
  *
  * @public
  */
 export declare interface PluginConfigs {
     rules: Record<string, FormKitValidationRule>;
     locales: FormKitLocaleRegistry;
     inputs: FormKitLibrary;
     messages: Record<string, Partial<FormKitLocale>>;
     locale: string;
     theme: string;
     iconLoaderUrl: FormKitIconLoaderUrl;
     iconLoader: FormKitIconLoader;
     icons: Record<string, string | undefined>;
 }

 /**
  * The types of values that can be rendered by Vue.
  *
  * @public
  */
 export declare type Renderable = null | string | number | boolean | VirtualNode;

 /**
  * A list of renderable items.
  *
  * @public
  */
 export declare type RenderableList = Renderable | Renderable[] | (Renderable | Renderable[])[];

 /**
  * A slot function that can be rendered.
  *
  * @public
  */
 export declare type RenderableSlot = (data?: Record<string, any>, key?: object) => RenderableList;

 /**
  * An object of slots
  *
  * @public
  */
 export declare type RenderableSlots = Record<string, RenderableSlot>;

 export { reset }

 export { resetCount }

 /**
  * The symbol that represents the formkit’s root element injection value.
  *
  * @public
  */
 export declare const rootSymbol: InjectionKey<Ref<Document | ShadowRoot | undefined>>;

 export { setErrors }

 /**
  * The type definition for the FormKit’s slots, this is not intended to be used
  * directly.
  * @public
  */
 export declare type Slots<Props extends FormKitInputs<Props>> = InputType<Props> extends keyof FormKitInputSlots<Props> ? FormKitInputSlots<Props>[InputType<Props>] : {};

 /**
  * Flush all callbacks registered with onSSRComplete for a given app.
  * @param app - The Vue application.
  * @public
  */
 export declare function ssrComplete(app: App<any>): void;

 export { submitForm }

 /**
  * A composable to provide a given configuration to all children.
  * @param config - A FormKit configuration object or a function
  */
 export declare function useConfig(config?: FormKitOptions | ((...args: any[]) => FormKitOptions)): void;

 /**
  * A composable for creating a new FormKit node.
  *
  * @param type - The type of node (input, group, list)
  * @param attrs - The FormKit "props" — which is really the attrs list.
  *
  * @returns {@link @formkit/core#FormKitNode | FormKitNode}
      *
      * @public
      */
  export declare function useInput<Props extends FormKitInputs<Props>, Context extends SetupContext<any, any>>(props: Props, context: Context, options?: FormKitOptions): FormKitNode;

  /**
   * The actual signature of a VNode in Vue.
   *
   * @public
   */
  export declare type VirtualNode = VNode<RendererNode, RendererElement, {
      [key: string]: any;
  }>;

  
/**
 * Augment Vue’s globalProperties.
 * @public
 */
declare module 'vue' {
  interface ComponentCustomProperties {
    $formkit: FormKitVuePlugin
  }
  interface GlobalComponents {
    FormKit: FormKitComponent
    FormKitSchema: typeof FormKitSchema
  }
}

declare global {
  var __FORMKIT_CONFIGS__: FormKitRootConfig[]
}

