"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
/**
 * Combine two effectful actions, keeping only the result of the first
 * @function
 */
function applyFirst(apply) {
    return function (fa) { return function (fb) { return apply.ap(apply.map(function (a) { return function_1.constant(a); }, fa), fb); }; };
}
exports.applyFirst = applyFirst;
/**
 * Combine two effectful actions, keeping only the result of the second
 * @function
 */
function applySecond(apply) {
    return function (fa) { return function (fb) { return apply.ap(apply.map(function () { return function_1.identity; }, fa), fb); }; };
}
exports.applySecond = applySecond;
/**
 * Lift a function of two arguments to a function which accepts and returns values wrapped with the type constructor `F`
 * @function
 */
function liftA2(apply) {
    return function (f) { return function (fa) { return function (fb) { return apply.ap(apply.map(f, fa), fb); }; }; };
}
exports.liftA2 = liftA2;
/**
 * Lift a function of three arguments to a function which accepts and returns values wrapped with the type constructor `F`
 * @function
 */
function liftA3(apply) {
    return function (f) { return function (fa) { return function (fb) { return function (fc) { return apply.ap(apply.ap(apply.map(f, fa), fb), fc); }; }; }; };
}
exports.liftA3 = liftA3;
/**
 * Lift a function of four arguments to a function which accepts and returns values wrapped with the type constructor `F`
 * @function
 */
function liftA4(apply) {
    return function (f) { return function (fa) { return function (fb) { return function (fc) { return function (fd) { return apply.ap(apply.ap(apply.ap(apply.map(f, fa), fb), fc), fd); }; }; }; }; };
}
exports.liftA4 = liftA4;
//# sourceMappingURL=Apply.js.map