import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Monoid } from './Monoid';
import { Applicative } from './Applicative';
import { Monad } from './Monad';
import { Foldable } from './Foldable';
import { Unfoldable } from './Unfoldable';
import { Traversable } from './Traversable';
import { Alternative } from './Alternative';
import { Plus } from './Plus';
import { Option } from './Option';
import { Ord } from './Ord';
import { Extend } from './Extend';
import { Predicate, Lazy, Endomorphism, Refinement } from './function';
import { Either } from './Either';
declare global  {
    interface Array<T> {
        _URI: URI;
        _A: T;
    }
}
declare module './HKT' {
    interface URI2HKT<A> {
        Array: Array<A>;
    }
}
export declare const URI = "Array";
export declare type URI = typeof URI;
/** @function */
export declare const empty: () => any[];
/** @function */
export declare const concat: <A>(x: A[]) => (y: A[]) => A[];
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: A[]) => B[];
/** @function */
export declare const of: <A>(a: A) => A[];
/** @function */
export declare const ap: <A, B>(fab: ((a: A) => B)[], fa: A[]) => B[];
/** @function */
export declare const chain: <A, B>(f: (a: A) => B[], fa: A[]) => B[];
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: A[]) => B;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: Array<A>) => HKT2As<F, L, Array<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: Array<A>) => HKTAs<F, Array<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Array<B>>;
/**
 * @function
 * @alias empty
 */
export declare const zero: () => any[];
/** @function */
export declare const alt: <A>(x: A[], y: A[]) => A[];
/** @function */
export declare const unfoldr: <A, B>(f: (b: B) => Option<[A, B]>, b: B) => A[];
/** @function */
export declare const extend: <A, B>(f: (fa: A[]) => B, fa: A[]) => B[];
/** @function */
export declare const partitionMap: <A, L, R>(f: (a: A) => Either<L, R>, fa: A[]) => {
    left: L[];
    right: R[];
};
/**
 * Example
 *
 * ```ts
 * flatten([[1], [2], [3]]) // [1, 2, 3]
 * ```
 *
 * @function
 */
export declare const flatten: <A>(ffa: A[][]) => A[];
/**
 * Break an array into its first element and remaining elements
 *
 * Example
 *
 * ```ts
 * const length = <A>(xs: Array<A>): number => fold(() => 0, (head, tail) => 1 + length(tail), xs)
 * ```
 *
 * @function
 */
export declare const fold: <A, B>(nil: Lazy<B>, cons: (head: A, tail: A[]) => B, as: A[]) => B;
/**
 * Get the number of elements in an array
 * @function
 */
export declare const length: <A>(as: A[]) => number;
/**
 * Test whether an array is empty
 * @function
 */
export declare const isEmpty: <A>(as: A[]) => boolean;
/**
 * Test whether an array contains a particular index
 * @function
 */
export declare const isOutOfBound: (i: number) => <A>(as: A[]) => boolean;
/**
 * This function provides a safe way to read a value at a particular index from an array
 * @function
 */
export declare const index: (i: number) => <A>(as: A[]) => Option<A>;
/**
 * Attaches an element to the front of an array, creating a new array
 */
export declare const cons: <A>(a: A) => (as: A[]) => A[];
/**
 * Append an element to the end of an array, creating a new array
 * @function
 */
export declare const snoc: <A>(as: A[]) => (a: A) => A[];
/**
 * Get the first element in an array, or `None` if the array is empty
 * @function
 */
export declare const head: <A>(as: A[]) => Option<A>;
/**
 * Get the last element in an array, or `None` if the array is empty
 * @function
 */
export declare const last: <A>(as: A[]) => Option<A>;
/**
 * Get all but the first element of an array, creating a new array, or `None` if the array is empty
 * @function
 */
export declare const tail: <A>(as: A[]) => Option<A[]>;
/**
 * Extract a subarray by a start and end index
 * @function
 */
export declare const slice: (start: number, end: number) => <A>(as: A[]) => A[];
/**
 * Get all but the last element of an array, creating a new array, or `None` if the array is empty
 * @function
 */
export declare const init: <A>(as: A[]) => Option<A[]>;
/**
 * Keep only a number of elements from the start of an array, creating a new array
 * @function
 */
export declare const take: (n: number) => <A>(as: A[]) => A[];
/**
 * Split an array into two parts:
 * 1. the longest initial subarray for which all elements satisfy the specified predicate
 * 2. the remaining elements
 * @function
 */
export declare const span: <A>(predicate: Predicate<A>) => (as: A[]) => {
    init: A[];
    rest: A[];
};
/**
 * Calculate the longest initial subarray for which all element satisfy the
 * specified predicate, creating a new array
 * @function
 */
export declare const takeWhile: <A>(predicate: Predicate<A>) => (as: A[]) => A[];
/**
 * Drop a number of elements from the start of an array, creating a new array
 * @function
 */
export declare const drop: (n: number) => <A>(as: A[]) => A[];
/**
 * Remove the longest initial subarray for which all element satisfy the
 * specified predicate, creating a new array
 * @function
 */
export declare const dropWhile: <A>(predicate: Predicate<A>) => (as: A[]) => A[];
/**
 * Find the first index for which a predicate holds
 * @function
 */
export declare const findIndex: <A>(predicate: Predicate<A>) => (as: A[]) => Option<number>;
/**
 * Find the first element which satisfies a predicate function
 * @function
 */
export declare const findFirst: <A>(predicate: Predicate<A>) => (as: A[]) => Option<A>;
/**
 * Find the last element which satisfies a predicate function
 * @function
 */
export declare const findLast: <A>(predicate: Predicate<A>) => (as: A[]) => Option<A>;
/**
 * Filter an array, keeping the elements which satisfy a predicate function, creating a new array
 * @function
 */
export declare const filter: <A>(predicate: Predicate<A>) => (as: A[]) => A[];
/** @function */
export declare const refine: <A>(as: A[]) => <B extends A>(refinement: Refinement<A, B>) => B[];
/** @function */
export declare const copy: <A>(as: A[]) => A[];
/** @function */
export declare const unsafeInsertAt: (i: number) => <A>(a: A) => (as: A[]) => A[];
/**
 * Insert an element at the specified index, creating a new array, or
 * returning `None` if the index is out of bounds
 * @function
 */
export declare const insertAt: (i: number) => <A>(a: A) => (as: A[]) => Option<A[]>;
/** @function */
export declare const unsafeUpdateAt: (i: number) => <A>(a: A) => (as: A[]) => A[];
/**
 * Change the element at the specified index, creating a new array, or
 * returning `None` if the index is out of bounds
 * @function
 */
export declare const updateAt: (i: number) => <A>(a: A) => (as: A[]) => Option<A[]>;
/** @function */
export declare const unsafeDeleteAt: (i: number) => <A>(as: A[]) => A[];
/**
 * Delete the element at the specified index, creating a new array, or
 * returning `None` if the index is out of bounds
 * @function
 */
export declare const deleteAt: (i: number) => <A>(as: A[]) => Option<A[]>;
/**
 * Apply a function to the element at the specified index, creating a new
 * array, or returning `None` if the index is out of bounds
 * @function
 */
export declare const modifyAt: (i: number) => <A>(f: Endomorphism<A>) => (as: A[]) => Option<A[]>;
/**
 * Reverse an array, creating a new array
 * @function
 */
export declare const reverse: <A>(as: A[]) => A[];
/**
 * Apply a function to each element in an array, keeping only the results
 * which contain a value, creating a new array
 * @function
 */
export declare const mapOption: <A, B>(f: (a: A) => Option<B>) => (as: A[]) => B[];
/**
 * Filter an array of optional values, keeping only the elements which contain
 * a value, creating a new array
 * @function
 */
export declare const catOptions: <A>(as: Option<A>[]) => A[];
/**
 * Extracts from a list of `Either` all the `Right` elements. All the `Right` elements are extracted in order
 * @function
 */
export declare const rights: <L, A>(as: Either<L, A>[]) => A[];
/**
 * Extracts from a list of `Either` all the `Left` elements. All the `Left` elements are extracted in order
 * @function
 */
export declare const lefts: <L, A>(as: Either<L, A>[]) => L[];
/**
 * Sort the elements of an array in increasing order, creating a new array
 * @function
 */
export declare const sort: <A>(ord: Ord<A>) => (as: A[]) => A[];
/**
 * Apply a function to pairs of elements at the same index in two arrays,
 * collecting the results in a new array.
 * If one input array is short, excess elements of the longer array are discarded.
 * @function
 */
export declare const zipWith: <A, B, C>(f: (a: A, b: B) => C) => (fa: A[]) => (fb: B[]) => C[];
/**
 * Takes two arrays and returns an array of corresponding pairs.
 * If one input array is short, excess elements of the longer array are discarded
 * @function
 */
export declare const zip: <A>(fa: A[]) => <B>(fb: B[]) => [A, B][];
export declare const array: Monoid<Array<any>> & Monad<URI> & Foldable<URI> & Unfoldable<URI> & Traversable<URI> & Alternative<URI> & Plus<URI> & Extend<URI>;
