import { Monoid } from './Monoid';
import { Functor, FantasyFunctor } from './Functor';
import { Contravariant, FantasyContravariant } from './Contravariant';
import { Applicative } from './Applicative';
import { Apply } from './Apply';
import { Semigroup } from './Semigroup';
import { Setoid } from './Setoid';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Const: Const<L, A>;
    }
}
export declare const URI = "Const";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Const
 */
export declare class Const<L, A> implements FantasyFunctor<URI, A>, FantasyContravariant<URI, A> {
    readonly value: L;
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: L);
    map<B, C>(f: (b: B) => C): Const<L, C>;
    contramap<B, C>(f: (c: C) => B): Const<L, C>;
    fold<B>(f: (l: L) => B): B;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const getSetoid: <L, A>(S: Setoid<L>) => Setoid<Const<L, A>>;
/** @function */
export declare const map: <L, A, B>(f: (a: A) => B, fa: Const<L, A>) => Const<L, B>;
/** @function */
export declare const contramap: <L, A, B>(f: (b: B) => A, fa: Const<L, A>) => Const<L, B>;
/** @function */
export declare const ap: <L>(S: Semigroup<L>) => <A, B>(fab: Const<L, (a: A) => B>, fa: Const<L, A>) => Const<L, B>;
/** @function */
export declare const getApply: <L>(S: Semigroup<L>) => Apply<"Const">;
/** @function */
export declare const of: <L>(M: Monoid<L>) => <A>(b: A) => Const<L, A>;
/** @function */
export declare const getApplicative: <L>(M: Monoid<L>) => Applicative<"Const">;
/** @instance */
export declare const const_: Functor<URI> & Contravariant<URI>;
