import { HKT, HKTS, HKT2S, HKT2, HKTAs, HKT2As } from './HKT';
import { Applicative } from './Applicative';
import { Monad, FantasyMonad } from './Monad';
import { Foldable, FantasyFoldable } from './Foldable';
import { Extend, FantasyExtend } from './Extend';
import { Setoid } from './Setoid';
import { Traversable, FantasyTraversable } from './Traversable';
import { Bifunctor, FantasyBifunctor } from './Bifunctor';
import { Alt, FantasyAlt } from './Alt';
import { ChainRec } from './ChainRec';
import { Option } from './Option';
import { Predicate, Lazy } from './function';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Either: Either<L, A>;
    }
}
export declare const URI = "Either";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Left
 * @constructor Right
 */
export declare type Either<L, A> = Left<L, A> | Right<L, A>;
export declare class Left<L, A> implements FantasyMonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlt<URI, A>, FantasyExtend<URI, A>, FantasyBifunctor<URI, L, A> {
    readonly value: L;
    readonly _tag: 'Left';
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: L);
    map<B>(f: (a: A) => B): Either<L, B>;
    ap<B>(fab: Either<L, (a: A) => B>): Either<L, B>;
    ap_<B, C>(this: Either<L, (a: B) => C>, fb: Either<L, B>): Either<L, C>;
    chain<B>(f: (a: A) => Either<L, B>): Either<L, B>;
    bimap<V, B>(f: (l: L) => V, g: (a: A) => B): Either<V, B>;
    alt(fy: Either<L, A>): Either<L, A>;
    extend<B>(f: (ea: Either<L, A>) => B): Either<L, B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2<F, M, B>) => HKT2As<F, M, Either<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKTAs<F, Either<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Either<L, B>>;
    /** Applies a function to each case in the data structure */
    fold<B>(left: (l: L) => B, right: (a: A) => B): B;
    /** Returns the value from this `Right` or the given argument if this is a `Left` */
    getOrElseValue(a: A): A;
    /** Returns the value from this `Right` or the result of given argument if this is a `Left` */
    getOrElse(f: (l: L) => A): A;
    /** Maps the left side of the disjunction */
    mapLeft<M>(f: (l: L) => M): Either<M, A>;
    toOption(): Option<A>;
    inspect(): string;
    toString(): string;
    /** Returns `true` if the either is an instance of `Left`, `false` otherwise */
    isLeft(): boolean;
    /** Returns `true` if the either is an instance of `Right`, `false` otherwise */
    isRight(): boolean;
    /** Swaps the disjunction values */
    swap(): Either<A, L>;
}
export declare class Right<L, A> implements FantasyMonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlt<URI, A>, FantasyExtend<URI, A> {
    readonly value: A;
    readonly _tag: 'Right';
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): Either<L, B>;
    ap<B>(fab: Either<L, (a: A) => B>): Either<L, B>;
    ap_<B, C>(this: Either<L, (a: B) => C>, fb: Either<L, B>): Either<L, C>;
    chain<B>(f: (a: A) => Either<L, B>): Either<L, B>;
    bimap<V, B>(f: (l: L) => V, g: (a: A) => B): Either<V, B>;
    alt(fy: Either<L, A>): Either<L, A>;
    extend<B>(f: (ea: Either<L, A>) => B): Either<L, B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2<F, M, B>) => HKT2As<F, M, Either<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKTAs<F, Either<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Either<L, B>>;
    fold<B>(left: (l: L) => B, right: (a: A) => B): B;
    getOrElseValue(a: A): A;
    getOrElse(f: (l: L) => A): A;
    mapLeft<M>(f: (l: L) => M): Either<M, A>;
    toOption(): Option<A>;
    inspect(): string;
    toString(): string;
    isLeft(): boolean;
    isRight(): boolean;
    swap(): Either<A, L>;
}
/**
 * Applies a function to each case in the data structure
 * @function
 */
export declare const fold: <L, A, B>(left: (l: L) => B, right: (a: A) => B) => (fa: Either<L, A>) => B;
/** @function */
export declare const getSetoid: <L, A>(SL: Setoid<L>, SA: Setoid<A>) => Setoid<Either<L, A>>;
/**
 * Returns the value from this `Right` or the given argument if this is a `Left`
 * @function
 */
export declare const getOrElseValue: <A>(a: A) => <L>(fa: Either<L, A>) => A;
/**
 * Returns the value from this `Right` or the result of given argument if this is a `Left`
 * @function
 */
export declare const getOrElse: <L, A>(f: (l: L) => A) => (fa: Either<L, A>) => A;
/** @function */
export declare const map: <L, A, B>(f: (a: A) => B, fa: Either<L, A>) => Either<L, B>;
/** @function */
export declare const of: <L, A>(a: A) => Either<L, A>;
/** @function */
export declare const ap: <L, A, B>(fab: Either<L, (a: A) => B>, fa: Either<L, A>) => Either<L, B>;
/** @function */
export declare const chain: <L, A, B>(f: (a: A) => Either<L, B>, fa: Either<L, A>) => Either<L, B>;
/** @function */
export declare const bimap: <L, V, A, B>(f: (u: L) => V, g: (a: A) => B, fla: Either<L, A>) => Either<V, B>;
/** @function */
export declare const alt: <L, A>(fx: Either<L, A>, fy: Either<L, A>) => Either<L, A>;
/** @function */
export declare const extend: <L, A, B>(f: (ea: Either<L, A>) => B, ea: Either<L, A>) => Either<L, B>;
/** @function */
export declare const reduce: <L, A, B>(f: (b: B, a: A) => B, b: B, fa: Either<L, A>) => B;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <M, L, A, B>(f: (a: A) => HKT2<F, M, B>, ta: Either<L, A>) => HKT2As<F, M, Either<L, B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT<F, B>, ta: Either<L, A>) => HKTAs<F, Either<L, B>>;
export declare function traverse<F>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Either<L, B>>;
/** @function */
export declare const chainRec: <L, A, B>(f: (a: A) => Either<L, Either<A, B>>, a: A) => Either<L, B>;
/**
 * Returns `true` if the either is an instance of `Left`, `false` otherwise
 * @function
 */
export declare const isLeft: <L, A>(fa: Either<L, A>) => fa is Left<L, A>;
/**
 * Returns `true` if the either is an instance of `Right`, `false` otherwise
 * @function
 */
export declare const isRight: <L, A>(fa: Either<L, A>) => fa is Right<L, A>;
/**
 * Constructs a new `Either` holding a `Left` value.
 * This usually represents a failure, due to the right-bias of this structure
 * @function
 */
export declare const left: <L, A>(l: L) => Either<L, A>;
/**
 * Constructs a new `Either` holding a `Right` value.
 * This usually represents a successful value due to the right bias of this structure
 * @function
 * @alias of
 */
export declare const right: <L, A>(a: A) => Either<L, A>;
/** @function */
export declare const fromPredicate: <L, A>(predicate: Predicate<A>, l: (a: A) => L) => (a: A) => Either<L, A>;
/**
 * Maps the left side of the disjunction
 * @function
 */
export declare const mapLeft: <L, M>(f: (l: L) => M) => <A>(fa: Either<L, A>) => Either<M, A>;
/**
 * Takes a default and a `Option` value, if the value is a `Some`, turn it into
 * a `Right`, if the value is a `None` use the provided default as a `Left`
 * @function
 */
export declare const fromOption: <L>(defaultValue: L) => <A>(fa: Option<A>) => Either<L, A>;
/**
 * Takes a default and a nullable value, if the value is not nully, turn it into
 * a `Right`, if the value is nully use the provided default as a `Left`
 * @function
 */
export declare const fromNullable: <L>(defaultValue: L) => <A>(a: A | null | undefined) => Either<L, A>;
/** @function */
export declare const toOption: <L, A>(fa: Either<L, A>) => Option<A>;
/** @function */
export declare const tryCatch: <A>(f: Lazy<A>) => Either<Error, A>;
/**
 * Swaps the disjunction values
 * @function
 */
export declare const swap: <L, A>(fa: Either<L, A>) => Either<A, L>;
/** @instance */
export declare const either: Monad<URI> & Foldable<URI> & Traversable<URI> & Bifunctor<URI> & Alt<URI> & Extend<URI> & ChainRec<URI>;
