"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ChainRec_1 = require("./ChainRec");
var Option_1 = require("./Option");
var function_1 = require("./function");
exports.URI = 'Either';
var Left = /** @class */ (function () {
    function Left(value) {
        this.value = value;
        this._tag = 'Left';
    }
    Left.prototype.map = function (f) {
        return this;
    };
    Left.prototype.ap = function (fab) {
        return (exports.isLeft(fab) ? fab : this);
    };
    Left.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Left.prototype.chain = function (f) {
        return this;
    };
    Left.prototype.bimap = function (f, g) {
        return new Left(f(this.value));
    };
    Left.prototype.alt = function (fy) {
        return fy;
    };
    Left.prototype.extend = function (f) {
        return this;
    };
    Left.prototype.reduce = function (f, b) {
        return b;
    };
    Left.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.of(_this); };
    };
    /** Applies a function to each case in the data structure */
    Left.prototype.fold = function (left, right) {
        return left(this.value);
    };
    /** Returns the value from this `Right` or the given argument if this is a `Left` */
    Left.prototype.getOrElseValue = function (a) {
        return a;
    };
    /** Returns the value from this `Right` or the result of given argument if this is a `Left` */
    Left.prototype.getOrElse = function (f) {
        return f(this.value);
    };
    /** Maps the left side of the disjunction */
    Left.prototype.mapLeft = function (f) {
        return exports.left(f(this.value));
    };
    Left.prototype.toOption = function () {
        return Option_1.none;
    };
    Left.prototype.inspect = function () {
        return this.toString();
    };
    Left.prototype.toString = function () {
        return "left(" + function_1.toString(this.value) + ")";
    };
    /** Returns `true` if the either is an instance of `Left`, `false` otherwise */
    Left.prototype.isLeft = function () {
        return true;
    };
    /** Returns `true` if the either is an instance of `Right`, `false` otherwise */
    Left.prototype.isRight = function () {
        return false;
    };
    /** Swaps the disjunction values */
    Left.prototype.swap = function () {
        return exports.right(this.value);
    };
    return Left;
}());
exports.Left = Left;
var Right = /** @class */ (function () {
    function Right(value) {
        this.value = value;
        this._tag = 'Right';
    }
    Right.prototype.map = function (f) {
        return new Right(f(this.value));
    };
    Right.prototype.ap = function (fab) {
        if (exports.isRight(fab)) {
            return this.map(fab.value);
        }
        return fab;
    };
    Right.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Right.prototype.chain = function (f) {
        return f(this.value);
    };
    Right.prototype.bimap = function (f, g) {
        return new Right(g(this.value));
    };
    Right.prototype.alt = function (fy) {
        return this;
    };
    Right.prototype.extend = function (f) {
        return new Right(f(this));
    };
    Right.prototype.reduce = function (f, b) {
        return f(b, this.value);
    };
    Right.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return exports.of(b); }, f(_this.value)); };
    };
    Right.prototype.fold = function (left, right) {
        return right(this.value);
    };
    Right.prototype.getOrElseValue = function (a) {
        return this.value;
    };
    Right.prototype.getOrElse = function (f) {
        return this.value;
    };
    Right.prototype.mapLeft = function (f) {
        return this;
    };
    Right.prototype.toOption = function () {
        return Option_1.some(this.value);
    };
    Right.prototype.inspect = function () {
        return this.toString();
    };
    Right.prototype.toString = function () {
        return "right(" + function_1.toString(this.value) + ")";
    };
    Right.prototype.isLeft = function () {
        return false;
    };
    Right.prototype.isRight = function () {
        return true;
    };
    Right.prototype.swap = function () {
        return exports.left(this.value);
    };
    return Right;
}());
exports.Right = Right;
/**
 * Applies a function to each case in the data structure
 * @function
 */
exports.fold = function (left, right) { return function (fa) {
    return fa.fold(left, right);
}; };
/** @function */
exports.getSetoid = function (SL, SA) {
    return {
        equals: function (x) { return function (y) {
            return x.fold(function (lx) { return y.fold(function (ly) { return SL.equals(lx)(ly); }, function_1.constFalse); }, function (ax) { return y.fold(function_1.constFalse, function (ay) { return SA.equals(ax)(ay); }); });
        }; }
    };
};
/**
 * Returns the value from this `Right` or the given argument if this is a `Left`
 * @function
 */
exports.getOrElseValue = function (a) { return function (fa) {
    return fa.getOrElseValue(a);
}; };
/**
 * Returns the value from this `Right` or the result of given argument if this is a `Left`
 * @function
 */
exports.getOrElse = function (f) { return function (fa) {
    return fa.getOrElse(f);
}; };
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new Right(a);
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @function */
exports.bimap = function (f, g, fla) {
    return fla.bimap(f, g);
};
/** @function */
exports.alt = function (fx, fy) {
    return fx.alt(fy);
};
/** @function */
exports.extend = function (f, ea) {
    return ea.extend(f);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @function */
exports.chainRec = function (f, a) {
    return ChainRec_1.tailRec(function (e) { return e.fold(function (l) { return exports.right(exports.left(l)); }, function (r) { return r.fold(function (a) { return exports.left(f(a)); }, function (b) { return exports.right(exports.right(b)); }); }); }, f(a));
};
/**
 * Returns `true` if the either is an instance of `Left`, `false` otherwise
 * @function
 */
exports.isLeft = function (fa) {
    return fa.isLeft();
};
/**
 * Returns `true` if the either is an instance of `Right`, `false` otherwise
 * @function
 */
exports.isRight = function (fa) {
    return fa.isRight();
};
/**
 * Constructs a new `Either` holding a `Left` value.
 * This usually represents a failure, due to the right-bias of this structure
 * @function
 */
exports.left = function (l) {
    return new Left(l);
};
/**
 * Constructs a new `Either` holding a `Right` value.
 * This usually represents a successful value due to the right bias of this structure
 * @function
 * @alias of
 */
exports.right = exports.of;
/** @function */
exports.fromPredicate = function (predicate, l) { return function (a) {
    return predicate(a) ? exports.right(a) : exports.left(l(a));
}; };
/**
 * Maps the left side of the disjunction
 * @function
 */
exports.mapLeft = function (f) { return function (fa) {
    return fa.mapLeft(f);
}; };
/**
 * Takes a default and a `Option` value, if the value is a `Some`, turn it into
 * a `Right`, if the value is a `None` use the provided default as a `Left`
 * @function
 */
exports.fromOption = function (defaultValue) { return function (fa) {
    return fa.fold(function () { return exports.left(defaultValue); }, function (a) { return exports.right(a); });
}; };
/**
 * Takes a default and a nullable value, if the value is not nully, turn it into
 * a `Right`, if the value is nully use the provided default as a `Left`
 * @function
 */
exports.fromNullable = function (defaultValue) { return function (a) {
    return a == null ? exports.left(defaultValue) : exports.right(a);
}; };
/** @function */
exports.toOption = function (fa) {
    return fa.toOption();
};
/** @function */
exports.tryCatch = function (f) {
    try {
        return exports.right(f());
    }
    catch (e) {
        return exports.left(e);
    }
};
/**
 * Swaps the disjunction values
 * @function
 */
exports.swap = function (fa) {
    return fa.swap();
};
/** @instance */
exports.either = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    reduce: exports.reduce,
    traverse: traverse,
    bimap: exports.bimap,
    alt: exports.alt,
    extend: exports.extend,
    chainRec: exports.chainRec
};
//# sourceMappingURL=Either.js.map