"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Applicative_1 = require("./Applicative");
var either = require("./Either");
function chain(F) {
    return function (f, fa) { return F.chain(function (e) { return e.fold(function (l) { return F.of(either.left(l)); }, function (a) { return f(a); }); }, fa); };
}
exports.chain = chain;
function right(F) {
    return function (ma) { return F.map(function (a) { return either.right(a); }, ma); };
}
exports.right = right;
function left(F) {
    return function (ml) { return F.map(function (l) { return either.left(l); }, ml); };
}
exports.left = left;
function fromEither(F) {
    return function (oa) { return F.of(oa); };
}
exports.fromEither = fromEither;
function fold(F) {
    return function (left, right, fa) { return F.map(function (e) { return e.fold(left, right); }, fa); };
}
exports.fold = fold;
function mapLeft(F) {
    return function (f) { return function (fa) { return F.map(function (e) { return e.mapLeft(f); }, fa); }; };
}
exports.mapLeft = mapLeft;
function toOption(F) {
    return function (fa) { return F.map(function (e) { return e.toOption(); }, fa); };
}
exports.toOption = toOption;
function getEitherT(M) {
    var applicativeComposition = Applicative_1.getApplicativeComposition(M, either);
    return __assign({}, applicativeComposition, { chain: chain(M) });
}
exports.getEitherT = getEitherT;
//# sourceMappingURL=EitherT.js.map