"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fieldNumber = {
    add: function (x) { return function (y) { return x + y; }; },
    zero: function () { return 0; },
    mul: function (x) { return function (y) { return x * y; }; },
    one: function () { return 1; },
    sub: function (x) { return function (y) { return x - y; }; },
    degree: function () { return 1; },
    div: function (x) { return function (y) { return x / y; }; },
    mod: function (x) { return function (y) { return x % y; }; }
};
/**
 * The *greatest common divisor* of two values
 * @function
 */
exports.gcd = function (S, field) {
    var zero = field.zero();
    var f = function (x) { return function (y) { return (S.equals(y)(zero) ? x : f(y)(field.mod(x)(y))); }; };
    return f;
};
/**
 * The *least common multiple* of two values
 * @function
 */
exports.lcm = function (setoid, field) {
    var zero = field.zero();
    return function (x) { return function (y) {
        return setoid.equals(x)(zero) || setoid.equals(y)(zero) ? zero : field.div(field.mul(x)(y))(exports.gcd(setoid, field)(x)(y));
    }; };
};
//# sourceMappingURL=Field.js.map