"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Monoid_1 = require("./Monoid");
var Apply_1 = require("./Apply");
var function_1 = require("./function");
/** @function */
exports.getFoldableComposition = function (F, G) {
    return {
        reduce: function (f, b, fga) { return F.reduce(function (b, ga) { return G.reduce(f, b, ga); }, b, fga); }
    };
};
/**
 * A default implementation of `foldMap` using `foldl`
 * @function
 */
exports.foldMap = function (F, M) { return function (f) { return function (fa) {
    return F.reduce(function (acc, x) { return M.concat(acc)(f(x)); }, M.empty(), fa);
}; }; };
/** @function */
exports.fold = function (F, M) { return function (fa) {
    return exports.foldMap(F, M)(function_1.identity)(fa);
}; };
/** @function */
exports.toArray = function (F) { return function (fa) {
    return exports.foldMap(F, Monoid_1.monoidArray)(function (a) { return [a]; })(fa);
}; };
/**
 * A default implementation of `foldr` using `foldMap`
 * @function
 */
exports.foldr = function (F) { return function (f) { return function (b) { return function (fa) {
    return exports.foldMap(F, Monoid_1.getEndomorphismMonoid())(f)(fa)(b);
}; }; }; };
/**
 * Fold a data structure, accumulating values in some `Monoid`, combining adjacent elements using the specified separator
 * @function
 */
exports.intercalate = function (F, M) { return function (sep) { return function (fm) {
    function go(_a, x) {
        var init = _a.init, acc = _a.acc;
        return init ? { init: false, acc: x } : { init: false, acc: M.concat(M.concat(acc)(sep))(x) };
    }
    return F.reduce(go, { init: true, acc: M.empty() }, fm).acc;
}; }; };
/**
 * Traverse a data structure, performing some effects encoded by an `Applicative` functor at each value, ignoring the final result.
 * @function
 */
function traverse_(M, F) {
    return function (f, fa) { return exports.toArray(F)(fa).reduce(function (mu, a) { return Apply_1.applyFirst(M)(mu)(f(a)); }, M.of(undefined)); };
}
exports.traverse_ = traverse_;
/**
 * Perform all of the effects in some data structure in the order given by the `Foldable` instance, ignoring the final result.
 * @function
 */
function sequence_(M, F) {
    return function (fa) { return traverse_(M, F)(function (ma) { return ma; }, fa); };
}
exports.sequence_ = sequence_;
//# sourceMappingURL=Foldable.js.map