import { HKT, HKT2, HKT3, HKTS, HKTAs, HKT2S, HKT2As, HKT3S, HKT3As } from './HKT';
import { FantasyMonad, Monad } from './Monad';
import { NaturalTransformation } from './NaturalTransformation';
export declare const URI = "Free";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Pure
 * @constructor Impure
 */
export declare type Free<F, A> = Pure<F, A> | Impure<F, A, any>;
export declare class Pure<F, A> implements FantasyMonad<URI, A> {
    readonly value: A;
    readonly _tag: 'Pure';
    readonly _A: A;
    readonly _L: F;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): Free<F, B>;
    ap<B>(fab: Free<F, (a: A) => B>): Free<F, B>;
    ap_<B, C>(this: Free<F, (a: B) => C>, fb: Free<F, B>): Free<F, C>;
    chain<B>(f: (a: A) => Free<F, B>): Free<F, B>;
    foldFree<M extends HKT3S>(M: Monad<M>): <U, L>(f: <A>(fa: HKT<F, A>) => HKT3<M, U, L, A>) => HKT3As<M, U, L, A>;
    foldFree<M extends HKT2S>(M: Monad<M>): <L>(f: <A>(fa: HKT<F, A>) => HKT2<M, L, A>) => HKT2As<M, L, A>;
    foldFree<M extends HKTS>(M: Monad<M>): (f: NaturalTransformation<F, M>) => HKTAs<M, A>;
    foldFree<M>(M: Monad<M>): (f: NaturalTransformation<F, M>) => HKT<M, A>;
    inspect(): string;
    toString(): string;
}
export declare class Impure<F, A, X> implements FantasyMonad<URI, A> {
    readonly fx: HKT<F, X>;
    readonly f: (x: X) => Free<F, A>;
    readonly _tag: 'Impure';
    readonly _A: A;
    readonly _L: F;
    readonly _URI: URI;
    constructor(fx: HKT<F, X>, f: (x: X) => Free<F, A>);
    map<B>(f: (a: A) => B): Free<F, B>;
    ap<B>(fab: Free<F, (a: A) => B>): Free<F, B>;
    ap_<B, C>(this: Free<F, (a: B) => C>, fb: Free<F, B>): Free<F, C>;
    chain<B>(f: (a: A) => Free<F, B>): Free<F, B>;
    foldFree<M extends HKT3S>(M: Monad<M>): <U, L>(f: <A>(fa: HKT<F, A>) => HKT3<M, U, L, A>) => HKT3As<M, U, L, A>;
    foldFree<M extends HKT2S>(M: Monad<M>): <L>(f: <A>(fa: HKT<F, A>) => HKT2<M, L, A>) => HKT2As<M, L, A>;
    foldFree<M extends HKTS>(M: Monad<M>): (f: NaturalTransformation<F, M>) => HKTAs<M, A>;
    foldFree<M>(M: Monad<M>): (f: NaturalTransformation<F, M>) => HKT<M, A>;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const of: <F, A>(a: A) => Free<F, A>;
/**
 * Lift an impure value described by the generating type constructor `F` into the free monad
 * @function
 */
export declare const liftF: <F, A>(fa: HKT<F, A>) => Free<F, A>;
/** @function */
export declare const substFree: <F, G>(f: <A>(fa: HKT<F, A>) => Free<G, A>) => <A>(fa: Free<F, A>) => Free<G, A>;
/**
 * Use a natural transformation to change the generating type constructor of a free monad
 * @function
 */
export declare function hoistFree<F extends HKT3S, G>(nt: <U, L, A>(fa: HKT3As<F, U, L, A>) => HKT<G, A>): (<A>(fa: Free<F, A>) => Free<G, A>);
export declare function hoistFree<F extends HKT2S, G>(nt: <L, A>(fa: HKT2As<F, L, A>) => HKT<G, A>): (<A>(fa: Free<F, A>) => Free<G, A>);
export declare function hoistFree<F extends HKTS, G>(nt: <A>(fa: HKTAs<F, A>) => HKT<G, A>): (<A>(fa: Free<F, A>) => Free<G, A>);
export declare function hoistFree<F, G>(nt: NaturalTransformation<F, G>): (<A>(fa: Free<F, A>) => Free<G, A>);
export declare function foldFree<M extends HKT3S>(M: Monad<M>): <F extends HKTS>(f: <A>(fa: HKTAs<F, A>) => HKT<M, A>) => <U, L, A>(fa: Free<F, A>) => HKT3As<M, U, L, A>;
export declare function foldFree<M extends HKT2S>(M: Monad<M>): <F extends HKTS>(f: <A>(fa: HKTAs<F, A>) => HKT<M, A>) => <L, A>(fa: Free<F, A>) => HKT2As<M, L, A>;
export declare function foldFree<M extends HKTS>(M: Monad<M>): <F extends HKTS>(f: <A>(fa: HKTAs<F, A>) => HKT<M, A>) => <A>(fa: Free<F, A>) => HKTAs<M, A>;
export declare function foldFree<M>(M: Monad<M>): <F>(f: NaturalTransformation<F, M>) => <A>(fa: Free<F, A>) => HKT<M, A>;
