"use strict";
// adapted from http://okmij.org/ftp/Computation/free-monad.html
// and https://github.com/purescript/purescript-free
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
exports.URI = 'Free';
var Pure = /** @class */ (function () {
    function Pure(value) {
        this.value = value;
        this._tag = 'Pure';
    }
    Pure.prototype.map = function (f) {
        return new Pure(f(this.value));
    };
    Pure.prototype.ap = function (fab) {
        var _this = this;
        return fab.chain(function (f) { return _this.map(f); }); // <- derived
    };
    Pure.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Pure.prototype.chain = function (f) {
        return f(this.value);
    };
    Pure.prototype.foldFree = function (M) {
        var _this = this;
        return function () { return M.of(_this.value); };
    };
    Pure.prototype.inspect = function () {
        return this.toString();
    };
    Pure.prototype.toString = function () {
        return "new Pure(" + function_1.toString(this.value) + ")";
    };
    return Pure;
}());
exports.Pure = Pure;
var Impure = /** @class */ (function () {
    function Impure(fx, f) {
        this.fx = fx;
        this.f = f;
        this._tag = 'Impure';
    }
    Impure.prototype.map = function (f) {
        var _this = this;
        return new Impure(this.fx, function (x) { return _this.f(x).map(f); });
    };
    Impure.prototype.ap = function (fab) {
        var _this = this;
        return fab.chain(function (f) { return _this.map(f); }); // <- derived
    };
    Impure.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Impure.prototype.chain = function (f) {
        var _this = this;
        return new Impure(this.fx, function (x) { return _this.f(x).chain(f); });
    };
    Impure.prototype.foldFree = function (M) {
        var _this = this;
        return function (f) { return M.chain(function (x) { return _this.f(x).foldFree(M)(f); }, f(_this.fx)); };
    };
    Impure.prototype.inspect = function () {
        return this.toString();
    };
    Impure.prototype.toString = function () {
        return "new Impure(" + (function_1.toString(this.fx), function_1.toString(this.f)) + ")";
    };
    return Impure;
}());
exports.Impure = Impure;
/** @function */
exports.of = function (a) {
    return new Pure(a);
};
/**
 * Lift an impure value described by the generating type constructor `F` into the free monad
 * @function
 */
exports.liftF = function (fa) {
    return new Impure(fa, function (a) { return exports.of(a); });
};
/** @function */
exports.substFree = function (f) {
    function go(fa) {
        switch (fa._tag) {
            case 'Pure':
                return exports.of(fa.value);
            case 'Impure':
                return f(fa.fx).chain(function (x) { return go(fa.f(x)); });
        }
    }
    return go;
};
/**
 * Use a natural transformation to change the generating type constructor of a free monad
 * @function
 */
function hoistFree(nt) {
    return exports.substFree(function (fa) { return exports.liftF(nt(fa)); });
}
exports.hoistFree = hoistFree;
/**
 * Note. This function is overloaded so, despite the argument `f` being ill-typed, is type safe
 * @function
 */
function foldFree(M) {
    return function (f) { return function (fa) { return fa.foldFree(M)(f); }; };
}
exports.foldFree = foldFree;
//# sourceMappingURL=Free.js.map