"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
function lift(F) {
    return function (f) { return function (fa) { return F.map(f, fa); }; };
}
exports.lift = lift;
function voidRight(F) {
    return function (a) { return function (fb) { return F.map(function_1.constant(a), fb); }; };
}
exports.voidRight = voidRight;
function voidLeft(F) {
    return function (fa) { return function (b) { return F.map(function_1.constant(b), fa); }; };
}
exports.voidLeft = voidLeft;
/**
 * Apply a value in a computational context to a value in no context. Generalizes `flip`
 * @function
 */
function flap(functor) {
    return function (ff) { return function (a) { return functor.map(function (f) { return f(a); }, ff); }; };
}
exports.flap = flap;
/** @function */
function getFunctorComposition(F, G) {
    return {
        map: function (f, fa) { return F.map(function (ga) { return G.map(f, ga); }, fa); }
    };
}
exports.getFunctorComposition = getFunctorComposition;
//# sourceMappingURL=Functor.js.map