import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Applicative } from './Applicative';
import { Monad, FantasyMonad } from './Monad';
import { Foldable, FantasyFoldable } from './Foldable';
import { Setoid } from './Setoid';
import { Traversable, FantasyTraversable } from './Traversable';
import { Alt, FantasyAlt } from './Alt';
import { Comonad, FantasyComonad } from './Comonad';
import { Either } from './Either';
import { ChainRec } from './ChainRec';
declare module './HKT' {
    interface URI2HKT<A> {
        Identity: Identity<A>;
    }
}
export declare const URI = "Identity";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Identity
 */
export declare class Identity<A> implements FantasyMonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlt<URI, A>, FantasyComonad<URI, A> {
    readonly value: A;
    readonly _A: A;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): Identity<B>;
    ap<B>(fab: Identity<(a: A) => B>): Identity<B>;
    ap_<B, C>(this: Identity<(a: B) => C>, fb: Identity<B>): Identity<C>;
    chain<B>(f: (a: A) => Identity<B>): Identity<B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(applicative: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, Identity<B>>;
    traverse<F extends HKTS>(applicative: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Identity<B>>;
    traverse<F>(applicative: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Identity<B>>;
    alt(fx: Identity<A>): Identity<A>;
    extract(): A;
    extend<B>(f: (ea: Identity<A>) => B): Identity<B>;
    fold<B>(f: (a: A) => B): B;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const getSetoid: <A>(setoid: Setoid<A>) => Setoid<Identity<A>>;
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: Identity<A>) => Identity<B>;
/** @function */
export declare const of: <A>(a: A) => Identity<A>;
/** @function */
export declare const ap: <A, B>(fab: Identity<(a: A) => B>, fa: Identity<A>) => Identity<B>;
/** @function */
export declare const chain: <A, B>(f: (a: A) => Identity<B>, fa: Identity<A>) => Identity<B>;
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: Identity<A>) => B;
/** @function */
export declare const alt: <A>(fx: Identity<A>, fy: Identity<A>) => Identity<A>;
/** @function */
export declare const extend: <A, B>(f: (ea: Identity<A>) => B, ea: Identity<A>) => Identity<B>;
/** @function */
export declare const extract: <A>(fa: Identity<A>) => A;
/** @function */
export declare const chainRec: <A, B>(f: (a: A) => Identity<Either<A, B>>, a: A) => Identity<B>;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: Identity<A>) => HKT2As<F, L, Identity<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: Identity<A>) => HKTAs<F, Identity<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Identity<B>>;
/** @instance */
export declare const identity: Monad<URI> & Foldable<URI> & Traversable<URI> & Alt<URI> & Comonad<URI> & ChainRec<URI>;
