"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ChainRec_1 = require("./ChainRec");
var function_1 = require("./function");
exports.URI = 'Identity';
/**
 * @data
 * @constructor Identity
 */
var Identity = /** @class */ (function () {
    function Identity(value) {
        this.value = value;
    }
    Identity.prototype.map = function (f) {
        return new Identity(f(this.value));
    };
    Identity.prototype.ap = function (fab) {
        return this.map(fab.extract());
    };
    Identity.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Identity.prototype.chain = function (f) {
        return f(this.extract());
    };
    Identity.prototype.reduce = function (f, b) {
        return f(b, this.value);
    };
    Identity.prototype.traverse = function (applicative) {
        var _this = this;
        return function (f) { return applicative.map(function (a) { return exports.of(a); }, f(_this.value)); };
    };
    Identity.prototype.alt = function (fx) {
        return this;
    };
    Identity.prototype.extract = function () {
        return this.value;
    };
    Identity.prototype.extend = function (f) {
        return exports.of(f(this));
    };
    Identity.prototype.fold = function (f) {
        return f(this.value);
    };
    Identity.prototype.inspect = function () {
        return this.toString();
    };
    Identity.prototype.toString = function () {
        return "new Identity(" + function_1.toString(this.value) + ")";
    };
    return Identity;
}());
exports.Identity = Identity;
/** @function */
exports.getSetoid = function (setoid) {
    return {
        equals: function (x) { return function (y) { return setoid.equals(x.value)(y.value); }; }
    };
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new Identity(a);
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
exports.alt = function (fx, fy) {
    return fx.alt(fy);
};
/** @function */
exports.extend = function (f, ea) {
    return ea.extend(f);
};
/** @function */
exports.extract = function (fa) {
    return fa.extract();
};
/** @function */
exports.chainRec = function (f, a) {
    return new Identity(ChainRec_1.tailRec(function (a) { return f(a).extract(); }, a));
};
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @instance */
exports.identity = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    reduce: exports.reduce,
    traverse: traverse,
    alt: exports.alt,
    extract: exports.extract,
    extend: exports.extend,
    chainRec: exports.chainRec
};
//# sourceMappingURL=Identity.js.map