import { Monad } from './Monad';
import { IxMonad, FantasyIxMonad } from './IxMonad';
import { IO } from './IO';
declare module './HKT' {
    interface URI2HKT3<U, L, A> {
        IxIO: IxIO<U, L, A>;
    }
}
export declare const URI = "IxIO";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor IxIO
 */
export declare class IxIO<I, O, A> implements FantasyIxMonad<URI, A, O, I> {
    readonly value: IO<A>;
    readonly _A: A;
    readonly _L: O;
    readonly _U: I;
    readonly _URI: URI;
    constructor(value: IO<A>);
    run(): A;
    ichain<Z, B>(f: (a: A) => IxIO<O, Z, B>): IxIO<I, Z, B>;
    map<B>(f: (a: A) => B): IxIO<I, O, B>;
    ap<B>(fab: IxIO<I, I, (a: A) => B>): IxIO<I, I, B>;
    chain<B>(f: (a: A) => IxIO<I, I, B>): IxIO<I, I, B>;
}
/** @function */
export declare const iof: <I, A>(a: A) => IxIO<I, I, A>;
/** @function */
export declare const ichain: <I, O, Z, A, B>(f: (a: A) => IxIO<O, Z, B>, fa: IxIO<I, O, A>) => IxIO<I, Z, B>;
/** @function */
export declare const map: <I, A, B>(f: (a: A) => B, fa: IxIO<I, I, A>) => IxIO<I, I, B>;
/**
 * @function
 * @alias iof
 */
export declare const of: <I, A>(a: A) => IxIO<I, I, A>;
/** @function */
export declare const ap: <I, A, B>(fab: IxIO<I, I, (a: A) => B>, fa: IxIO<I, I, A>) => IxIO<I, I, B>;
/** @function */
export declare const chain: <I, A, B>(f: (a: A) => IxIO<I, I, B>, fa: IxIO<I, I, A>) => IxIO<I, I, B>;
/** @instance */
export declare const ixIO: Monad<URI> & IxMonad<URI>;
