"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var io = require("./IO");
exports.URI = 'IxIO';
/**
 * @data
 * @constructor IxIO
 */
var IxIO = /** @class */ (function () {
    function IxIO(value) {
        this.value = value;
    }
    IxIO.prototype.run = function () {
        return this.value.run();
    };
    IxIO.prototype.ichain = function (f) {
        return new IxIO(this.value.chain(function (a) { return f(a).value; }));
    };
    IxIO.prototype.map = function (f) {
        return new IxIO(this.value.map(f));
    };
    IxIO.prototype.ap = function (fab) {
        return new IxIO(this.value.ap(fab.value));
    };
    IxIO.prototype.chain = function (f) {
        return new IxIO(this.value.chain(function (a) { return f(a).value; }));
    };
    return IxIO;
}());
exports.IxIO = IxIO;
/** @function */
exports.iof = function (a) {
    return new IxIO(io.of(a));
};
/** @function */
exports.ichain = function (f, fa) {
    return fa.ichain(f);
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/**
 * @function
 * @alias iof
 */
exports.of = exports.iof;
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @instance */
exports.ixIO = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    iof: exports.iof,
    ichain: exports.ichain
};
//# sourceMappingURL=IxIO.js.map