import { Semigroup } from './Semigroup';
import { Endomorphism } from './function';
/** @typeclass */
export interface Monoid<A> extends Semigroup<A> {
    empty: () => A;
}
/** @function */
export declare const fold: <A>(M: Monoid<A>) => (as: A[]) => A;
/** @function */
export declare const getProductMonoid: <A, B>(MA: Monoid<A>, MB: Monoid<B>) => Monoid<[A, B]>;
/** @function */
export declare const getDualMonoid: <A>(M: Monoid<A>) => Monoid<A>;
/**
 * Boolean monoid under conjunction
 * @instance
 */
export declare const monoidAll: Monoid<boolean>;
/**
 * Boolean monoid under disjunction
 * @instance
 */
export declare const monoidAny: Monoid<boolean>;
/**
 * Monoid under array concatenation (`Array<any>`)
 * @instance
 */
export declare const monoidArray: Monoid<Array<any>>;
/**
 * Number monoid under addition
 * @instance
 */
export declare const monoidSum: Monoid<number>;
/**
 * Number monoid under multiplication
 * @instance
 */
export declare const monoidProduct: Monoid<number>;
/** @instance */
export declare const monoidString: Monoid<string>;
/** @function */
export declare const getFunctionMonoid: <M>(monoid: Monoid<M>) => <A>() => Monoid<(a: A) => M>;
/** @function */
export declare const getEndomorphismMonoid: <A>() => Monoid<Endomorphism<A>>;
/**
 * Returns a monoid under array concatenation
 * @function
 */
export declare const getArrayMonoid: <A>() => Monoid<A[]>;
/** @function */
export declare const getRecordMonoid: <O extends {
    [key: string]: any;
}>(monoids: {
    [K in keyof O]: Monoid<O[K]>;
}) => Monoid<{
    [K in keyof O]: O[K];
}>;
