"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Semigroup_1 = require("./Semigroup");
var function_1 = require("./function");
/** @function */
exports.fold = function (M) { return function (as) {
    return Semigroup_1.fold(M)(M.empty())(as);
}; };
/** @function */
exports.getProductMonoid = function (MA, MB) {
    var empty = [MA.empty(), MB.empty()];
    return __assign({}, Semigroup_1.getProductSemigroup(MA, MB), { empty: function () { return empty; } });
};
/** @function */
exports.getDualMonoid = function (M) {
    return __assign({}, Semigroup_1.getDualSemigroup(M), { empty: M.empty });
};
/**
 * Boolean monoid under conjunction
 * @instance
 */
exports.monoidAll = {
    concat: function (x) { return function (y) { return x && y; }; },
    empty: function () { return true; }
};
/**
 * Boolean monoid under disjunction
 * @instance
 */
exports.monoidAny = {
    concat: function (x) { return function (y) { return x || y; }; },
    empty: function () { return false; }
};
/**
 * Monoid under array concatenation (`Array<any>`)
 * @instance
 */
exports.monoidArray = {
    concat: function (x) { return function (y) { return x.concat(y); }; },
    empty: function () { return []; }
};
/**
 * Number monoid under addition
 * @instance
 */
exports.monoidSum = {
    concat: function (x) { return function (y) { return x + y; }; },
    empty: function () { return 0; }
};
/**
 * Number monoid under multiplication
 * @instance
 */
exports.monoidProduct = {
    concat: function (x) { return function (y) { return x * y; }; },
    empty: function () { return 1; }
};
/** @instance */
exports.monoidString = {
    concat: function (x) { return function (y) { return x + y; }; },
    empty: function () { return ''; }
};
/** @function */
exports.getFunctionMonoid = function (monoid) { return function () {
    var empty = function_1.constant(function_1.constant(monoid.empty()));
    return {
        concat: function (f) { return function (g) { return function (a) { return monoid.concat(f(a))(g(a)); }; }; },
        empty: empty
    };
}; };
/** @function */
exports.getEndomorphismMonoid = function () {
    return {
        concat: function (x) { return function (y) { return function_1.compose(x, y); }; },
        empty: function () { return function_1.identity; }
    };
};
/**
 * Returns a monoid under array concatenation
 * @function
 */
exports.getArrayMonoid = function () {
    return exports.monoidArray;
};
/** @function */
exports.getRecordMonoid = function (monoids) {
    var empty = {};
    for (var k in monoids) {
        empty[k] = monoids[k].empty();
    }
    return __assign({}, Semigroup_1.getRecordSemigroup(monoids), { empty: function () { return empty; } });
};
//# sourceMappingURL=Monoid.js.map