import { HKT } from './HKT';
import { Functor } from './Functor';
import { Applicative } from './Applicative';
/**
 * Applicative functors are equivalent to strong lax monoidal functors
 * - https://wiki.haskell.org/Typeclassopedia#Alternative_formulation
 * - https://bartoszmilewski.com/2017/02/06/applicative-functors/
 * @typeclass
 */
export interface Monoidal<F> extends Functor<F> {
    unit(): HKT<F, void>;
    mult<A, B>(fa: HKT<F, A>, fb: HKT<F, B>): HKT<F, [A, B]>;
}
/** @function */
export declare const fromApplicative: <F>(applicative: Applicative<F>) => Monoidal<F>;
/** @function */
export declare const toApplicative: <F>(monoidal: Monoidal<F>) => Applicative<F>;
