"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
var Apply_1 = require("./Apply");
/** @function */
exports.fromApplicative = function (applicative) {
    return {
        URI: applicative.URI,
        map: applicative.map,
        unit: function () { return applicative.of(undefined); },
        mult: function (fa, fb) { return Apply_1.liftA2(applicative)(function_1.tupleCurried)(fa)(fb); }
    };
};
/** @function */
exports.toApplicative = function (monoidal) {
    return {
        URI: monoidal.URI,
        map: monoidal.map,
        of: function (a) { return monoidal.map(function_1.constant(a), monoidal.unit()); },
        ap: function (fab, fa) { return monoidal.map(function (_a) {
            var f = _a[0], a = _a[1];
            return f(a);
        }, monoidal.mult(fab, fa)); }
    };
};
//# sourceMappingURL=Monoidal.js.map