import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Monad, FantasyMonad } from './Monad';
import { Comonad, FantasyComonad } from './Comonad';
import { Semigroup } from './Semigroup';
import { Foldable, FantasyFoldable } from './Foldable';
import { Applicative } from './Applicative';
import { Traversable, FantasyTraversable } from './Traversable';
import { Option } from './Option';
declare module './HKT' {
    interface URI2HKT<A> {
        NonEmptyArray: NonEmptyArray<A>;
    }
}
export declare const URI = "NonEmptyArray";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor NonEmptyArray
 */
export declare class NonEmptyArray<A> implements FantasyMonad<URI, A>, FantasyComonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly head: A;
    readonly tail: Array<A>;
    readonly _A: A;
    readonly _URI: URI;
    constructor(head: A, tail: Array<A>);
    toArray(): Array<A>;
    concatArray(as: Array<A>): NonEmptyArray<A>;
    map<B>(f: (a: A) => B): NonEmptyArray<B>;
    ap<B>(fab: NonEmptyArray<(a: A) => B>): NonEmptyArray<B>;
    ap_<B, C>(this: NonEmptyArray<(a: B) => C>, fb: NonEmptyArray<B>): NonEmptyArray<C>;
    chain<B>(f: (a: A) => NonEmptyArray<B>): NonEmptyArray<B>;
    concat(y: NonEmptyArray<A>): NonEmptyArray<A>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(applicative: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, NonEmptyArray<B>>;
    traverse<F extends HKTS>(applicative: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, NonEmptyArray<B>>;
    traverse<F>(applicative: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, NonEmptyArray<B>>;
    extend<B>(f: (fa: NonEmptyArray<A>) => B): NonEmptyArray<B>;
    extract(): A;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const fromArray: <A>(as: A[]) => Option<NonEmptyArray<A>>;
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: NonEmptyArray<A>) => NonEmptyArray<B>;
/** @function */
export declare const of: <A>(a: A) => NonEmptyArray<A>;
/** @function */
export declare const ap: <A, B>(fab: NonEmptyArray<(a: A) => B>, fa: NonEmptyArray<A>) => NonEmptyArray<B>;
/** @function */
export declare const chain: <A, B>(f: (a: A) => NonEmptyArray<B>, fa: NonEmptyArray<A>) => NonEmptyArray<B>;
/** @function */
export declare const concat: <A>(fx: NonEmptyArray<A>) => (fy: NonEmptyArray<A>) => NonEmptyArray<A>;
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: NonEmptyArray<A>) => B;
/** @function */
export declare const extend: <A, B>(f: (fa: NonEmptyArray<A>) => B, fa: NonEmptyArray<A>) => NonEmptyArray<B>;
/** @function */
export declare const extract: <A>(fa: NonEmptyArray<A>) => A;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: NonEmptyArray<A>) => HKT2As<F, L, NonEmptyArray<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: NonEmptyArray<A>) => HKTAs<F, NonEmptyArray<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, NonEmptyArray<B>>;
/** @instance */
export declare const nonEmptyArray: Monad<URI> & Comonad<URI> & Semigroup<any> & Foldable<URI> & Traversable<URI>;
