"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var array = require("./Array");
var Option_1 = require("./Option");
var function_1 = require("./function");
exports.URI = 'NonEmptyArray';
/**
 * @data
 * @constructor NonEmptyArray
 */
var NonEmptyArray = /** @class */ (function () {
    function NonEmptyArray(head, tail) {
        this.head = head;
        this.tail = tail;
    }
    NonEmptyArray.prototype.toArray = function () {
        return [this.head].concat(this.tail);
    };
    NonEmptyArray.prototype.concatArray = function (as) {
        return new NonEmptyArray(this.head, this.tail.concat(as));
    };
    NonEmptyArray.prototype.map = function (f) {
        return new NonEmptyArray(f(this.head), this.tail.map(f));
    };
    NonEmptyArray.prototype.ap = function (fab) {
        var _this = this;
        return fab.chain(function (f) { return _this.map(f); }); // <= derived
    };
    NonEmptyArray.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    NonEmptyArray.prototype.chain = function (f) {
        return f(this.head).concatArray(array.chain(function (a) { return f(a).toArray(); }, this.tail));
    };
    NonEmptyArray.prototype.concat = function (y) {
        return this.concatArray(y.toArray());
    };
    NonEmptyArray.prototype.reduce = function (f, b) {
        return array.reduce(f, b, this.toArray());
    };
    NonEmptyArray.prototype.traverse = function (applicative) {
        var _this = this;
        return function (f) { return applicative.map(function (bs) { return unsafeFromArray(bs); }, array.traverse(applicative)(f, _this.toArray())); };
    };
    NonEmptyArray.prototype.extend = function (f) {
        return unsafeFromArray(array.extend(function (as) { return f(unsafeFromArray(as)); }, this.toArray()));
    };
    NonEmptyArray.prototype.extract = function () {
        return this.head;
    };
    NonEmptyArray.prototype.inspect = function () {
        return this.toString();
    };
    NonEmptyArray.prototype.toString = function () {
        return "new NonEmptyArray(" + function_1.toString(this.head) + ", " + function_1.toString(this.tail) + ")";
    };
    return NonEmptyArray;
}());
exports.NonEmptyArray = NonEmptyArray;
var unsafeFromArray = function (as) {
    return new NonEmptyArray(as[0], as.slice(1));
};
/** @function */
exports.fromArray = function (as) {
    return as.length ? Option_1.some(unsafeFromArray(as)) : Option_1.none;
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new NonEmptyArray(a, []);
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @function */
exports.concat = function (fx) { return function (fy) {
    return fx.concat(fy);
}; };
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
exports.extend = function (f, fa) {
    return fa.extend(f);
};
/** @function */
exports.extract = function (fa) {
    return fa.extract();
};
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @instance */
exports.nonEmptyArray = {
    URI: exports.URI,
    extend: exports.extend,
    extract: exports.extract,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    concat: exports.concat,
    reduce: exports.reduce,
    traverse: traverse
};
//# sourceMappingURL=NonEmptyArray.js.map