import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Monoid } from './Monoid';
import { Applicative } from './Applicative';
import { Semigroup } from './Semigroup';
import { Monad, FantasyMonad } from './Monad';
import { Foldable, FantasyFoldable } from './Foldable';
import { Plus } from './Plus';
import { Extend, FantasyExtend } from './Extend';
import { Setoid } from './Setoid';
import { Traversable, FantasyTraversable } from './Traversable';
import { Alternative, FantasyAlternative } from './Alternative';
import { Lazy, Predicate } from './function';
declare module './HKT' {
    interface URI2HKT<A> {
        Option: Option<A>;
    }
}
export declare const URI = "Option";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor None
 * @constructor Some
 */
export declare type Option<A> = None<A> | Some<A>;
export declare class None<A> implements FantasyMonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlternative<URI, A>, FantasyExtend<URI, A> {
    static value: Option<never>;
    readonly _tag: 'None';
    readonly _A: A;
    readonly _URI: URI;
    private constructor();
    map<B>(f: (a: A) => B): Option<B>;
    /** Maps `f` over this Option's value. If the value returned from `f` is null or undefined, returns `None` */
    mapNullable<B>(f: (a: A) => B | null | undefined): Option<B>;
    ap<B>(fab: Option<(a: A) => B>): Option<B>;
    ap_<B, C>(this: Option<(a: B) => C>, fb: Option<B>): Option<C>;
    chain<B>(f: (a: A) => Option<B>): Option<B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, Option<B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Option<B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Option<B>>;
    alt(fa: Option<A>): Option<A>;
    extend<B>(f: (ea: Option<A>) => B): Option<B>;
    /** Applies a function to each case in the data structure */
    fold<B>(n: Lazy<B>, s: (a: A) => B): B;
    getOrElseValue(a: A): A;
    getOrElse(f: Lazy<A>): A;
    toNullable(): A | null;
    toUndefined(): A | undefined;
    inspect(): string;
    toString(): string;
    /** Returns `true` if the option has an element that is equal (as determined by `S`) to `a`, `false` otherwise */
    contains(S: Setoid<A>, a: A): boolean;
    /** Returns `true` if the option is `None`, `false` otherwise */
    isNone(): boolean;
    /** Returns `true` if the option is an instance of `Some`, `false` otherwise */
    isSome(): boolean;
    /** Returns `true` if this option is non empty and the predicate `p` returns `true` when applied to this Option's value */
    exists(p: (a: A) => boolean): boolean;
    /** Returns this option if it is non empty and the predicate `p` return `true` when applied to this Option's value. Otherwise returns `None` */
    filter(p: Predicate<A>): Option<A>;
}
export declare const none: Option<never>;
export declare class Some<A> implements FantasyMonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlternative<URI, A>, FantasyExtend<URI, A> {
    readonly value: A;
    readonly _tag: 'Some';
    readonly _A: A;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): Option<B>;
    mapNullable<B>(f: (a: A) => B | null | undefined): Option<B>;
    ap<B>(fab: Option<(a: A) => B>): Option<B>;
    ap_<B, C>(this: Option<(a: B) => C>, fb: Option<B>): Option<C>;
    chain<B>(f: (a: A) => Option<B>): Option<B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, Option<B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Option<B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Option<B>>;
    alt(fa: Option<A>): Option<A>;
    extend<B>(f: (ea: Option<A>) => B): Option<B>;
    fold<B>(n: Lazy<B>, s: (a: A) => B): B;
    getOrElseValue(a: A): A;
    getOrElse(f: Lazy<A>): A;
    toNullable(): A | null;
    toUndefined(): A | undefined;
    inspect(): string;
    toString(): string;
    contains(S: Setoid<A>, a: A): boolean;
    isNone(): boolean;
    isSome(): boolean;
    exists(p: (a: A) => boolean): boolean;
    filter(p: Predicate<A>): Option<A>;
}
/**
 * Applies a function to each case in the data structure
 * @function
 */
export declare const fold: <A, B>(n: Lazy<B>, s: (a: A) => B) => (fa: Option<A>) => B;
/** @function */
export declare const getSetoid: <A>(S: Setoid<A>) => Setoid<Option<A>>;
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: Option<A>) => Option<B>;
/**
 * Maps `f` over this Option's value. If the value returned from `f` is null or undefined, returns `None`
 * @function
 */
export declare const mapNullable: <A, B>(f: (a: A) => B | null | undefined, fa: Option<A>) => Option<B>;
/** @function */
export declare const of: <A>(a: A) => Option<A>;
export declare const ap: <A, B>(fab: Option<(a: A) => B>, fa: Option<A>) => Option<B>;
/** @function */
/** @function */
export declare const chain: <A, B>(f: (a: A) => Option<B>, fa: Option<A>) => Option<B>;
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: Option<A>) => B;
/**
 * Returns this option if it is non empty and the predicate `p` return `true` when applied to this Option's value. Otherwise returns none
 * @function
 */
export declare const filter: <A>(p: Predicate<A>) => (fa: Option<A>) => Option<A>;
/** @function */
export declare const alt: <A>(fx: Option<A>, fy: Option<A>) => Option<A>;
/** @function */
export declare const extend: <A, B>(f: (ea: Option<A>) => B, ea: Option<A>) => Option<B>;
/** @function */
export declare const zero: <A>() => Option<A>;
/**
 * @function
 * @alias zero
 */
export declare const empty: <A>() => Option<A>;
/**
 * Option monoid returning the left-most non-None value
 * @function
 */
export declare const getFirstMonoid: <A>() => Monoid<Option<A>>;
/**
 * Option monoid returning the right-most non-None value
 * @function
 */
export declare const getLastMonoid: <A>() => Monoid<Option<A>>;
/** @function */
export declare const getSemigroup: <A>(S: Semigroup<A>) => Semigroup<Option<A>>;
/** @function */
export declare const getMonoid: <A>(S: Semigroup<A>) => Monoid<Option<A>>;
/**
 * Returns `true` if the option is an instance of `Some`, `false` otherwise
 * @function
 */
export declare const isSome: <A>(fa: Option<A>) => fa is Some<A>;
/**
 * Returns `true` if the option is `None`, `false` otherwise
 * @function
 */
export declare const isNone: <A>(fa: Option<A>) => fa is None<A>;
/**
 * Takes a default value, and a `Option` value. If the `Option` value is
 * `None` the default value is returned, otherwise the value inside the
 * `Some` is returned
 * @function
 */
export declare const getOrElseValue: <A>(a: A) => (fa: Option<A>) => A;
/** @function */
export declare const getOrElse: <A>(f: Lazy<A>) => (fa: Option<A>) => A;
/**
 * Constructs a new `Option` from a nullable type.
 * If the value is `null` or `undefined`, returns `None`, otherwise returns the value wrapped in a `Some`
 * @function
 */
export declare const fromNullable: <A>(a: A | null | undefined) => Option<A>;
/** @function */
export declare const toNullable: <A>(fa: Option<A>) => A | null;
/** @function */
export declare const toUndefined: <A>(fa: Option<A>) => A | undefined;
/**
 * @function
 * @alias of
 */
export declare const some: <A>(a: A) => Option<A>;
/** @function */
export declare const fromPredicate: <A>(predicate: Predicate<A>) => (a: A) => Option<A>;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: Option<A>) => HKT2As<F, L, Option<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: Option<A>) => HKTAs<F, Option<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Option<B>>;
/** @instance */
export declare const option: Monad<URI> & Foldable<URI> & Plus<URI> & Traversable<URI> & Alternative<URI> & Extend<URI>;
