"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Monoid_1 = require("./Monoid");
var function_1 = require("./function");
exports.URI = 'Option';
var None = /** @class */ (function () {
    function None() {
        this._tag = 'None';
    }
    None.prototype.map = function (f) {
        return exports.none;
    };
    /** Maps `f` over this Option's value. If the value returned from `f` is null or undefined, returns `None` */
    None.prototype.mapNullable = function (f) {
        return exports.none;
    };
    None.prototype.ap = function (fab) {
        return exports.none;
    };
    None.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    None.prototype.chain = function (f) {
        return exports.none;
    };
    None.prototype.reduce = function (f, b) {
        return b;
    };
    None.prototype.traverse = function (F) {
        return function (f) { return F.of(exports.none); };
    };
    None.prototype.alt = function (fa) {
        return fa;
    };
    None.prototype.extend = function (f) {
        return exports.none;
    };
    /** Applies a function to each case in the data structure */
    None.prototype.fold = function (n, s) {
        return n();
    };
    None.prototype.getOrElseValue = function (a) {
        return a;
    };
    None.prototype.getOrElse = function (f) {
        return f();
    };
    None.prototype.toNullable = function () {
        return null;
    };
    None.prototype.toUndefined = function () {
        return undefined;
    };
    None.prototype.inspect = function () {
        return this.toString();
    };
    None.prototype.toString = function () {
        return 'none';
    };
    /** Returns `true` if the option has an element that is equal (as determined by `S`) to `a`, `false` otherwise */
    None.prototype.contains = function (S, a) {
        return false;
    };
    /** Returns `true` if the option is `None`, `false` otherwise */
    None.prototype.isNone = function () {
        return true;
    };
    /** Returns `true` if the option is an instance of `Some`, `false` otherwise */
    None.prototype.isSome = function () {
        return false;
    };
    /** Returns `true` if this option is non empty and the predicate `p` returns `true` when applied to this Option's value */
    None.prototype.exists = function (p) {
        return false;
    };
    /** Returns this option if it is non empty and the predicate `p` return `true` when applied to this Option's value. Otherwise returns `None` */
    None.prototype.filter = function (p) {
        return exports.none;
    };
    None.value = new None();
    return None;
}());
exports.None = None;
exports.none = None.value;
var Some = /** @class */ (function () {
    function Some(value) {
        this.value = value;
        this._tag = 'Some';
    }
    Some.prototype.map = function (f) {
        return new Some(f(this.value));
    };
    Some.prototype.mapNullable = function (f) {
        return exports.fromNullable(f(this.value));
    };
    Some.prototype.ap = function (fab) {
        var _this = this;
        return fab.map(function (f) { return f(_this.value); });
    };
    Some.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Some.prototype.chain = function (f) {
        return f(this.value);
    };
    Some.prototype.reduce = function (f, b) {
        return this.fold(function_1.constant(b), function (a) { return f(b, a); });
    };
    Some.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return exports.some(b); }, f(_this.value)); };
    };
    Some.prototype.alt = function (fa) {
        return this;
    };
    Some.prototype.extend = function (f) {
        return new Some(f(this));
    };
    Some.prototype.fold = function (n, s) {
        return s(this.value);
    };
    Some.prototype.getOrElseValue = function (a) {
        return this.value;
    };
    Some.prototype.getOrElse = function (f) {
        return this.value;
    };
    Some.prototype.toNullable = function () {
        return this.value;
    };
    Some.prototype.toUndefined = function () {
        return this.value;
    };
    Some.prototype.inspect = function () {
        return this.toString();
    };
    Some.prototype.toString = function () {
        return "some(" + function_1.toString(this.value) + ")";
    };
    Some.prototype.contains = function (S, a) {
        return S.equals(this.value)(a);
    };
    Some.prototype.isNone = function () {
        return false;
    };
    Some.prototype.isSome = function () {
        return true;
    };
    Some.prototype.exists = function (p) {
        return p(this.value);
    };
    Some.prototype.filter = function (p) {
        return this.exists(p) ? this : exports.none;
    };
    return Some;
}());
exports.Some = Some;
/**
 * Applies a function to each case in the data structure
 * @function
 */
exports.fold = function (n, s) { return function (fa) {
    return fa.fold(n, s);
}; };
/** @function */
exports.getSetoid = function (S) {
    return {
        equals: function (x) { return function (y) { return x.fold(function () { return y.isNone(); }, function (ax) { return y.fold(function () { return false; }, function (ay) { return S.equals(ax)(ay); }); }); }; }
    };
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/**
 * Maps `f` over this Option's value. If the value returned from `f` is null or undefined, returns `None`
 * @function
 */
exports.mapNullable = function (f, fa) {
    return fa.mapNullable(f);
};
/** @function */
exports.of = function (a) {
    return new Some(a);
};
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/**
 * Returns this option if it is non empty and the predicate `p` return `true` when applied to this Option's value. Otherwise returns none
 * @function
 */
exports.filter = function (p) { return function (fa) {
    return fa.filter(p);
}; };
/** @function */
exports.alt = function (fx, fy) {
    return fx.alt(fy);
};
/** @function */
exports.extend = function (f, ea) {
    return ea.extend(f);
};
/** @function */
exports.zero = function () {
    return exports.none;
};
/**
 * @function
 * @alias zero
 */
exports.empty = exports.zero;
/**
 * Option monoid returning the left-most non-None value
 * @function
 */
exports.getFirstMonoid = function () {
    return {
        concat: function (x) { return function (y) { return exports.alt(x, y); }; },
        empty: exports.empty
    };
};
/**
 * Option monoid returning the right-most non-None value
 * @function
 */
exports.getLastMonoid = function () {
    return Monoid_1.getDualMonoid(exports.getFirstMonoid());
};
/** @function */
exports.getSemigroup = function (S) {
    return {
        concat: function (x) { return function (y) { return x.fold(function () { return y; }, function (ax) { return y.fold(function () { return x; }, function (ay) { return exports.some(S.concat(ax)(ay)); }); }); }; }
    };
};
/** @function */
exports.getMonoid = function (S) {
    return __assign({}, exports.getSemigroup(S), { empty: exports.empty });
};
/**
 * Returns `true` if the option is an instance of `Some`, `false` otherwise
 * @function
 */
exports.isSome = function (fa) {
    return fa.isSome();
};
/**
 * Returns `true` if the option is `None`, `false` otherwise
 * @function
 */
exports.isNone = function (fa) {
    return fa.isNone();
};
/**
 * Takes a default value, and a `Option` value. If the `Option` value is
 * `None` the default value is returned, otherwise the value inside the
 * `Some` is returned
 * @function
 */
exports.getOrElseValue = function (a) { return function (fa) {
    return fa.getOrElseValue(a);
}; };
/** @function */
exports.getOrElse = function (f) { return function (fa) {
    return fa.getOrElse(f);
}; };
/**
 * Constructs a new `Option` from a nullable type.
 * If the value is `null` or `undefined`, returns `None`, otherwise returns the value wrapped in a `Some`
 * @function
 */
exports.fromNullable = function (a) {
    return a == null ? exports.none : new Some(a);
};
/** @function */
exports.toNullable = function (fa) {
    return fa.toNullable();
};
/** @function */
exports.toUndefined = function (fa) {
    return fa.toUndefined();
};
/**
 * @function
 * @alias of
 */
exports.some = exports.of;
/** @function */
exports.fromPredicate = function (predicate) { return function (a) {
    return predicate(a) ? exports.some(a) : exports.none;
}; };
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @instance */
exports.option = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    reduce: exports.reduce,
    traverse: traverse,
    zero: exports.zero,
    alt: exports.alt,
    extend: exports.extend
};
//# sourceMappingURL=Option.js.map