import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Functor } from './Functor';
import { Monad } from './Monad';
import { Applicative, ApplicativeComposition, ApplicativeComposition11, ApplicativeComposition21 } from './Applicative';
import { Option, URI as OptionURI } from './Option';
import { Lazy } from './function';
export interface OptionT<M> extends ApplicativeComposition<M, OptionURI> {
    chain<A, B>(f: (a: A) => HKT<M, Option<B>>, fa: HKT<M, Option<A>>): HKT<M, Option<B>>;
}
export interface OptionT1<M extends HKTS> extends ApplicativeComposition11<M, OptionURI> {
    chain<A, B>(f: (a: A) => HKTAs<M, Option<B>>, fa: HKTAs<M, Option<A>>): HKTAs<M, Option<B>>;
}
export interface OptionT2<M extends HKT2S> extends ApplicativeComposition21<M, OptionURI> {
    chain<L, A, B>(f: (a: A) => HKT2As<M, L, Option<B>>, fa: HKT2As<M, L, Option<A>>): HKT2As<M, L, Option<B>>;
}
export declare function chain<F extends HKT2S>(F: Monad<F>): OptionT2<F>['chain'];
export declare function chain<F extends HKTS>(F: Monad<F>): OptionT1<F>['chain'];
export declare function chain<F>(F: Monad<F>): OptionT<F>['chain'];
export declare function some<F extends HKT2S>(F: Applicative<F>): <L, A>(a: A) => HKT2As<F, L, Option<A>>;
export declare function some<F extends HKTS>(F: Applicative<F>): <A>(a: A) => HKTAs<F, Option<A>>;
export declare function some<F>(F: Applicative<F>): <A>(a: A) => HKT<F, Option<A>>;
export declare function none<F extends HKT2S>(F: Applicative<F>): <L>() => HKT2As<F, L, Option<any>>;
export declare function none<F extends HKTS>(F: Applicative<F>): () => HKTAs<F, Option<any>>;
export declare function none<F>(F: Applicative<F>): () => HKT<F, Option<any>>;
export declare function fromOption<F extends HKT2S>(F: Applicative<F>): <L, A>(fa: Option<A>) => HKT2As<F, L, Option<A>>;
export declare function fromOption<F extends HKTS>(F: Applicative<F>): <A>(fa: Option<A>) => HKTAs<F, Option<A>>;
export declare function fromOption<F>(F: Applicative<F>): <A>(fa: Option<A>) => HKT<F, Option<A>>;
export declare function liftF<F extends HKT2S>(F: Functor<F>): <L, A>(fa: HKT2As<F, L, A>) => HKT2As<F, L, Option<A>>;
export declare function liftF<F extends HKTS>(F: Functor<F>): <A>(fa: HKTAs<F, A>) => HKTAs<F, Option<A>>;
export declare function liftF<F>(F: Functor<F>): <A>(fa: HKT<F, A>) => HKT<F, Option<A>>;
export declare function fold<F extends HKT2S>(F: Functor<F>): <L, R, A>(none: Lazy<R>, some: (a: A) => R, fa: HKT2As<F, L, Option<A>>) => HKT2As<F, L, R>;
export declare function fold<F extends HKTS>(F: Functor<F>): <R, A>(none: Lazy<R>, some: (a: A) => R, fa: HKTAs<F, Option<A>>) => HKTAs<F, R>;
export declare function fold<F>(F: Functor<F>): <R, A>(none: Lazy<R>, some: (a: A) => R, fa: HKT<F, Option<A>>) => HKT<F, R>;
export declare function getOrElse<F extends HKT2S>(F: Functor<F>): <A>(f: Lazy<A>) => <L>(fa: HKT2As<F, L, Option<A>>) => HKT2As<F, L, A>;
export declare function getOrElse<F extends HKTS>(F: Functor<F>): <A>(f: Lazy<A>) => (fa: HKTAs<F, Option<A>>) => HKTAs<F, A>;
export declare function getOrElse<F>(F: Functor<F>): <A>(f: Lazy<A>) => (fa: HKT<F, Option<A>>) => HKT<F, A>;
export declare function getOrElseValue<F extends HKT2S>(F: Functor<F>): <A>(value: A) => <L>(fa: HKT2As<F, L, Option<A>>) => HKT2As<F, L, A>;
export declare function getOrElseValue<F extends HKTS>(F: Functor<F>): <A>(value: A) => (fa: HKTAs<F, Option<A>>) => HKTAs<F, A>;
export declare function getOrElseValue<F>(F: Functor<F>): <A>(value: A) => (fa: HKT<F, Option<A>>) => HKT<F, A>;
export declare function getOptionT<M extends HKT2S>(M: Monad<M>): OptionT2<M>;
export declare function getOptionT<M extends HKTS>(M: Monad<M>): OptionT1<M>;
export declare function getOptionT<M>(M: Monad<M>): OptionT<M>;
