"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Applicative_1 = require("./Applicative");
var option = require("./Option");
/** @function */
function chain(F) {
    return function (f, fa) { return F.chain(function (o) { return o.fold(function () { return F.of(option.none); }, function (a) { return f(a); }); }, fa); };
}
exports.chain = chain;
/** @function */
function some(F) {
    return function (a) { return F.of(option.some(a)); };
}
exports.some = some;
/** @function */
function none(F) {
    return function () { return F.of(option.none); };
}
exports.none = none;
/** @function */
function fromOption(F) {
    return function (oa) { return F.of(oa); };
}
exports.fromOption = fromOption;
/** @function */
function liftF(F) {
    return function (fa) { return F.map(function (a) { return option.some(a); }, fa); };
}
exports.liftF = liftF;
/** @function */
function fold(F) {
    return function (none, some, fa) { return F.map(function (o) { return o.fold(none, some); }, fa); };
}
exports.fold = fold;
/** @function */
function getOrElse(F) {
    return function (f) { return function (fa) { return F.map(function (o) { return o.getOrElse(f); }, fa); }; };
}
exports.getOrElse = getOrElse;
/** @function */
function getOrElseValue(F) {
    return function (value) { return function (fa) { return F.map(function (o) { return o.getOrElseValue(value); }, fa); }; };
}
exports.getOrElseValue = getOrElseValue;
/** @function */
function getOptionT(M) {
    var applicativeComposition = Applicative_1.getApplicativeComposition(M, option);
    return __assign({}, applicativeComposition, { chain: chain(M) });
}
exports.getOptionT = getOptionT;
//# sourceMappingURL=OptionT.js.map