"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Ordering_1 = require("./Ordering");
var Setoid_1 = require("./Setoid");
var function_1 = require("./function");
/** @function */
exports.toNativeComparator = function (compare) {
    return function (x, y) {
        var c = compare(x)(y);
        return c === 'GT' ? 1 : c === 'EQ' ? 0 : -1;
    };
};
/** @function */
exports.unsafeCompare = function (x) { return function (y) {
    return x < y ? 'LT' : x > y ? 'GT' : 'EQ';
}; };
/** @instance */
exports.ordString = __assign({}, Setoid_1.setoidString, { compare: exports.unsafeCompare });
/** @instance */
exports.ordNumber = __assign({}, Setoid_1.setoidNumber, { compare: exports.unsafeCompare });
/** @instance */
exports.ordBoolean = __assign({}, Setoid_1.setoidBoolean, { compare: exports.unsafeCompare });
/**
 * Test whether one value is _strictly less than_ another
 * @function
 */
exports.lessThan = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) === 'LT';
}; }; };
/**
 * Test whether one value is _strictly greater than_ another
 * @function
 */
exports.greaterThan = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) === 'GT';
}; }; };
/**
 * Test whether one value is _non-strictly less than_ another
 * @function
 */
exports.lessThanOrEq = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) !== 'GT';
}; }; };
/**
 * Test whether one value is _non-strictly greater than_ another
 * @function
 */
exports.greaterThanOrEq = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) !== 'LT';
}; }; };
/**
 * Take the minimum of two values. If they are considered equal, the first argument is chosen
 * @function
 */
exports.min = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) === 'GT' ? y : x;
}; }; };
/**
 * Take the maximum of two values. If they are considered equal, the first argument is chosen
 * @function
 */
exports.max = function (ord) { return function (x) { return function (y) {
    return ord.compare(x)(y) === 'LT' ? y : x;
}; }; };
/**
 * Clamp a value between a minimum and a maximum
 * @function
 */
exports.clamp = function (ord) { return function (low) { return function (hi) { return function (x) {
    return exports.min(ord)(hi)(exports.max(ord)(low)(x));
}; }; }; };
/**
 * Test whether a value is between a minimum and a maximum (inclusive)
 * @function
 */
exports.between = function (ord) { return function (low) { return function (hi) { return function (x) {
    return exports.lessThan(ord)(x)(low) || exports.greaterThan(ord)(x)(hi) ? false : true;
}; }; }; };
/** @function */
exports.fromCompare = function (compare) {
    return {
        equals: function (x) { return function (y) { return compare(x)(y) === 'EQ'; }; },
        compare: compare
    };
};
/** @function */
exports.contramap = function (f, fa) {
    return exports.fromCompare(function_1.on(fa.compare)(f));
};
/** @function */
exports.getSemigroup = function () {
    return {
        concat: function (x) { return function (y) { return exports.fromCompare(function (a) { return function (b) { return Ordering_1.semigroupOrdering.concat(x.compare(a)(b))(y.compare(a)(b)); }; }); }; }
    };
};
//# sourceMappingURL=Ord.js.map