import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Endomorphism } from './function';
import { Setoid } from './Setoid';
import { Ord } from './Ord';
import { Applicative } from './Applicative';
import { Semigroup } from './Semigroup';
import { Monoid } from './Monoid';
import { Foldable } from './Foldable';
import { Traversable } from './Traversable';
import { Comonad } from './Comonad';
declare module './HKT' {
    interface URI2HKT<A> {
        Pair: Pair<A>;
    }
}
export declare const URI = "Pair";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Pair
 */
export declare class Pair<A> {
    readonly value: [A, A];
    readonly _A: A;
    readonly _URI: URI;
    constructor(value: [A, A]);
    fst(): A;
    snd(): A;
    /** Map a function over the first field of a pair */
    first(f: Endomorphism<A>): Pair<A>;
    /** Map a function over the second field of a pair */
    second(f: Endomorphism<A>): Pair<A>;
    /** Swaps the elements in a pair */
    swap(): Pair<A>;
    map<B>(f: (a: A) => B): Pair<B>;
    ap<B>(fab: Pair<(a: A) => B>): Pair<B>;
    ap_<B, C>(this: Pair<(a: B) => C>, fb: Pair<B>): Pair<C>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, Pair<B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Pair<B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Pair<B>>;
    extract(): A;
    extend<B>(f: (fb: Pair<A>) => B): Pair<B>;
}
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: Pair<A>) => Pair<B>;
/** @function */
export declare const of: <A>(a: A) => Pair<A>;
/** @function */
export declare const ap: <A, B>(fab: Pair<(a: A) => B>, fa: Pair<A>) => Pair<B>;
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: Pair<A>) => B;
/** @function */
export declare const extract: <A>(fa: Pair<A>) => A;
/** @function */
export declare const extend: <A, B>(f: (fb: Pair<A>) => B, fa: Pair<A>) => Pair<B>;
/** @function */
export declare const getSetoid: <A>(S: Setoid<A>) => Setoid<Pair<A>>;
/** @function */
export declare const getOrd: <A>(O: Ord<A>) => Ord<Pair<A>>;
/** @function */
export declare const getSemigroup: <A>(S: Semigroup<A>) => Semigroup<Pair<A>>;
/** @function */
export declare const getMonoid: <A>(M: Monoid<A>) => Monoid<Pair<A>>;
/**
 * Map a function over the first field of a pair
 * @function
 */
export declare const first: <A>(f: Endomorphism<A>) => (fa: Pair<A>) => Pair<A>;
/**
 * Map a function over the second field of a pair
 * @function
 */
export declare const second: <A>(f: Endomorphism<A>) => (fa: Pair<A>) => Pair<A>;
/**
 * Swaps the elements in a pair
 * @function
 */
export declare const swap: <A>(fa: Pair<A>) => Pair<A>;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: Pair<A>) => HKT2As<F, L, Pair<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: Pair<A>) => HKTAs<F, Pair<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Pair<B>>;
/** @instance */
export declare const pair: Applicative<URI> & Foldable<URI> & Traversable<URI> & Comonad<URI>;
