"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Ordering_1 = require("./Ordering");
var Apply_1 = require("./Apply");
exports.URI = 'Pair';
/**
 * @data
 * @constructor Pair
 */
var Pair = /** @class */ (function () {
    function Pair(value) {
        this.value = value;
    }
    Pair.prototype.fst = function () {
        return this.value[0];
    };
    Pair.prototype.snd = function () {
        return this.value[1];
    };
    /** Map a function over the first field of a pair */
    Pair.prototype.first = function (f) {
        return new Pair([f(this.fst()), this.snd()]);
    };
    /** Map a function over the second field of a pair */
    Pair.prototype.second = function (f) {
        return new Pair([this.fst(), f(this.snd())]);
    };
    /** Swaps the elements in a pair */
    Pair.prototype.swap = function () {
        return new Pair([this.snd(), this.fst()]);
    };
    Pair.prototype.map = function (f) {
        return new Pair([f(this.fst()), f(this.snd())]);
    };
    Pair.prototype.ap = function (fab) {
        return new Pair([fab.fst()(this.fst()), fab.snd()(this.snd())]);
    };
    Pair.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Pair.prototype.reduce = function (f, b) {
        return f(f(b, this.fst()), this.snd());
    };
    Pair.prototype.traverse = function (F) {
        var _this = this;
        return function (f) {
            return Apply_1.liftA2(F)(function (b1) { return function (b2) { return new Pair([b1, b2]); }; })(f(_this.fst()))(f(_this.snd()));
        };
    };
    Pair.prototype.extract = function () {
        return this.fst();
    };
    Pair.prototype.extend = function (f) {
        return new Pair([f(this), f(this.swap())]);
    };
    return Pair;
}());
exports.Pair = Pair;
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new Pair([a, a]);
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
exports.extract = function (fa) {
    return fa.extract();
};
/** @function */
exports.extend = function (f, fa) {
    return fa.extend(f);
};
/** @function */
exports.getSetoid = function (S) {
    return {
        equals: function (x) { return function (y) { return S.equals(x.fst())(y.fst()) && S.equals(x.snd())(y.snd()); }; }
    };
};
/** @function */
exports.getOrd = function (O) {
    return __assign({}, exports.getSetoid(O), { compare: function (x) { return function (y) { return Ordering_1.semigroupOrdering.concat(O.compare(x.fst())(y.fst()))(O.compare(x.snd())(y.snd())); }; } });
};
/** @function */
exports.getSemigroup = function (S) {
    return {
        concat: function (x) { return function (y) { return new Pair([S.concat(x.fst())(y.fst()), S.concat(x.snd())(y.snd())]); }; }
    };
};
/** @function */
exports.getMonoid = function (M) {
    var empty = new Pair([M.empty(), M.empty()]);
    return __assign({}, exports.getSemigroup(M), { empty: function () { return empty; } });
};
/**
 * Map a function over the first field of a pair
 * @function
 */
exports.first = function (f) { return function (fa) {
    return fa.first(f);
}; };
/**
 * Map a function over the second field of a pair
 * @function
 */
exports.second = function (f) { return function (fa) {
    return fa.second(f);
}; };
/**
 * Swaps the elements in a pair
 * @function
 */
exports.swap = function (fa) {
    return fa.swap();
};
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @instance */
exports.pair = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    reduce: exports.reduce,
    traverse: traverse,
    extend: exports.extend,
    extract: exports.extract
};
//# sourceMappingURL=Pair.js.map