import { HKT2, HKT2S, HKT2As, HKT3S, HKT3As } from './HKT';
import { Functor, FantasyFunctor } from './Functor';
/** @typeclass */
export interface Profunctor<F> extends Functor<F> {
    promap<A, B, C, D>(f: (a: A) => B, g: (c: C) => D, fbc: HKT2<F, B, C>): HKT2<F, A, D>;
}
export interface FantasyProfunctor<F, B, C> extends FantasyFunctor<F, C> {
    promap: <A, D>(f: (a: A) => B, g: (c: C) => D) => HKT2<F, A, D>;
}
export declare function lmap<F extends HKT3S>(profunctor: Profunctor<F>): <A, B>(f: (a: A) => B) => <U, C>(fbc: HKT3As<F, U, B, C>) => HKT3As<F, U, A, C>;
export declare function lmap<F extends HKT2S>(profunctor: Profunctor<F>): <A, B>(f: (a: A) => B) => <C>(fbc: HKT2As<F, B, C>) => HKT2As<F, A, C>;
export declare function lmap<F>(profunctor: Profunctor<F>): <A, B>(f: (a: A) => B) => <C>(fbc: HKT2<F, B, C>) => HKT2<F, A, C>;
export declare function rmap<F extends HKT3S>(profunctor: Profunctor<F>): <C, D>(g: (c: C) => D) => <U, B>(fbc: HKT3As<F, U, B, C>) => HKT3As<F, U, B, D>;
export declare function rmap<F extends HKT2S>(profunctor: Profunctor<F>): <C, D>(g: (c: C) => D) => <B>(fbc: HKT2As<F, B, C>) => HKT2As<F, B, D>;
export declare function rmap<F>(profunctor: Profunctor<F>): <C, D>(g: (c: C) => D) => <B>(fbc: HKT2<F, B, C>) => HKT2<F, B, D>;
